/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>
#include <stdlib.h>

#include <mom/c/libcast.h>

#include <mom/c/pbe.hh>

mu_state::mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions,
		   char *which)
{
	int i;

	pres = _pres;
	stub_inline_depth = (int *) mustmalloc(sizeof(int) *
					       _pres->stubs.stubs_len);
	for (i = 0; i < (signed int)_pres->stubs.stubs_len; ++i)
		stub_inline_depth[i] = 0;
	
	which_stub = which;
	op = _op;
	current_param_dir = PRES_C_DIRECTION_UNKNOWN;
	assumptions = _assumptions;
	now_packing = 0;
	c_block = 0;
	array_def = 0;	
	
	/* Set our SID (security identifier) CAST expressions to null. */
	client_sid_cexpr = 0;
	server_sid_cexpr = 0;

	/* no arglist initially */
	arglist = NULL;
}

mu_state::mu_state(const mu_state &must)
{
	int i;
	
	pres = must.pres;
	stub_inline_depth = (int *) mustmalloc(sizeof(int) *
					       pres->stubs.stubs_len);
	for (i = 0; i < (signed int)pres->stubs.stubs_len; ++i)
		stub_inline_depth[i] = must.stub_inline_depth[i];
	
	which_stub = must.which_stub;
	op = must.op;
	current_param_dir = must.current_param_dir;
	assumptions = must.assumptions;
	now_packing = must.now_packing;
	
	client_sid_cexpr =	must.client_sid_cexpr;
	server_sid_cexpr =	must.server_sid_cexpr;
	
	/* Since the c_block is built incrementally while marshaling,
	   we must create a copy of the cast_block.
	   However, the copy doesn't need to go any deeper than that.  */
	if(must.c_block) {
		cast_block *ob = &must.c_block->cast_stmt_u_u.block;
		
		if(ob) {
			c_block = cast_new_block(ob->scope.cast_scope_len,
						 ob->stmts.stmts_len);
			cast_block *nb = &c_block->cast_stmt_u_u.block;
			memcpy(nb->scope.cast_scope_val, ob->scope.cast_scope_val,
			       ob->scope.cast_scope_len * sizeof(cast_def));
			memcpy(nb->stmts.stmts_val, ob->stmts.stmts_val,
			       ob->stmts.stmts_len * sizeof(cast_stmt));
		} else
			c_block = 0;
	} else
		c_block = 0;
	
	array_def = must.array_def;

	arglist = must.arglist;
}

mu_state::~mu_state()
{
	free(stub_inline_depth);
}

char *mu_state::get_which_stub()
{
	return which_stub;
}

/* End of file. */

