/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>
#include <stdlib.h>

#include <mom/c/libcast.h>
#include <mom/c/pbe.hh>
#include <mom/compiler.h>

void mu_state_arglist::add(char *nm)
{
	argument *tmp = (argument *)mustmalloc(sizeof(argument));

	tmp->name = (char *)mustmalloc(strlen(nm)+1);
	strcpy(tmp->name, nm);
	tmp->next = arg_list;
	tmp->cexpr = NULL;
	tmp->ctype = NULL;
	arg_list = tmp;
}

void mu_state_arglist::remove(char *nm)
{
	argument **tmp = &arg_list;

	while (*tmp) {
		if (strcmp(nm,(*tmp)->name)==0)
			*tmp = (*tmp)->next;
		tmp = &((*tmp)->next);
	}
}

int mu_state_arglist::getargs(char *nm, cast_expr *expr, cast_type *type)
{
	argument *tmp = arg_list;

	while (tmp) {
		if (strcmp(nm,tmp->name)==0) {
			*expr = tmp->cexpr;
			*type = tmp->ctype;
			return TRUE;
		}
		tmp = tmp->next;
	}
	*expr = NULL;
	*type = NULL;
	return FALSE;
}

int mu_state_arglist::setargs(char *nm, cast_expr expr, cast_type type)
{
	argument *tmp = arg_list;

	while (tmp) {
		if (strcmp(nm,tmp->name)==0) {
			tmp->cexpr = expr;
			tmp->ctype = type;
			return TRUE;
		}
		tmp = tmp->next;
	}
	return FALSE;
}
