/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>
#include <ctype.h>

#include <mom/compiler.h>
#include <mom/c/pbe.hh>

/*****************************************************************************/

#define ifdef_symbol_prefix "_"
#define ifdef_symbol_suffix "_"

/* The symbol that protects against multiple inclusion. */
static char *ifdef_symbol;

/*****/

void w_header_prologue(be_flags *flags, pres_c_1 * /*pres*/)
{
	if (flags->header) {
		/*
		 * Use the name of the header file construct the name of the C
		 * preprocessor symbol that will protect the header file from
		 * multiple inclusion.
		 *
		 * The current strategy for producing the symbol name could be
		 * improved.  The output file name might not be unique across a
		 * given project; all non-alphanumerics are mapped to `_'; etc.
		 */
		ifdef_symbol = flick_asprintf("%s%s%s%s",
					      ifdef_symbol_prefix,
					      (flags->prefix ?
					       flags->prefix : ""),
					      flags->header,
					      ifdef_symbol_suffix);
		for (char *cur = ifdef_symbol; *cur; cur++)
			if (!isalnum(*cur))
				*cur = '_';
		
		w_printf("#ifndef %s\n",   ifdef_symbol);
		w_printf("#define %s\n\n", ifdef_symbol);
	}
}

void w_header_epilogue(be_flags *flags, pres_c_1 * /*pres*/)
{
	if (flags->header)
		w_printf("#endif /* %s */\n", ifdef_symbol);
}

/* End of file. */

