/*
 * Copyright (c) 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/idl_id.h>
#include <mom/mint_special.h>
#include <mom/compiler.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "mach3.h"

void mach3_mu_state::mu_mapping_string(cast_expr ptr,
				       cast_type ptr_ctype,
				       mint_array_def *arr,
				       pres_c_allocation *mem_alloc)
{
	/* do the default thing */
	mem_mu_state::mu_mapping_string(ptr, ptr_ctype, arr, mem_alloc);

	/* the macros add an additional 4 or 12 bytes for the type
           header in the message, so update the max_msg_size.  We must
           do this because the macros use their own globbing, where
           the max_msg_size is usually taken care of. */
	max_msg_size += 12;
}

/* End of file. */

