/*
 * Copyright (c) 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/idl_id.h>
#include <mom/mint_special.h>
#include <mom/compiler.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "mach3.h"

void mach3_mu_state::mu_mapping_terminated_array(
	cast_expr expr,
	cast_type ctype, 
	mint_ref itype, 
	pres_c_mapping_terminated_array *tmap)
{
	assert(itype >= 0);
	assert(itype < (signed int) pres->mint.defs.defs_len);
	
	mint_def *def = &pres->mint.defs.defs_val[itype];
	assert((def->kind == MINT_ARRAY)|| (def->kind == MINT_VOID));
	unsigned len_min, len_max;

	if (def->kind == MINT_ARRAY) {
		mint_get_array_len(&pres->mint, itype,
				   &len_min, &len_max);
	} else if (def->kind == MINT_VOID) {
		len_min = len_max = tmap->max;
	} else
		panic("In `mach3_mu_state::mu_mapping_terminated_array',"
		      "unknown kind %d.",
		      def->kind);
	
	is_string = 1;
	if ((len_min == len_max && len_max > 0)) {
		pres_c_mapping_fixed_array fmap;
		
		/* fixed-length string */
		fmap.alloc = tmap->alloc;
		fmap.length = tmap->max;
		fmap.element_mapping = tmap->element_mapping;
		mem_mu_state::mu_mapping_fixed_array(expr, ctype,
						     itype, &fmap);
		is_string = 0;
		return;
	}
	
	/* do the default thing */
	mu_state::mu_mapping_terminated_array(expr, ctype, itype, tmap);
	is_string = 0;
}

/* End of file. */

