/*
 * Copyright (c) 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/c/libcast.h>
#include <mom/c/pbe.hh>

#include "mach3.h"

void mach3_mu_state::mu_pointer_alloc(cast_expr pexpr,
				      cast_type target_type,
				      cast_expr length_expr,
				      pres_c_allocation *alloc)
{
	if (!(op & MUST_ALLOCATE))
		return;
	
	if ((alloc->flags & PRES_C_ALLOC_EVER) == PRES_C_ALLOC_NEVER)
		return;
	
	/* Do the normal thing first */
	mem_mu_state::mu_pointer_alloc(pexpr, target_type, length_expr, alloc);
	
	assert(target_type);
	cast_type ctype = cast_find_typedef_type(&(pres->cast), target_type);

	/*
	 * XXX - This is a really ugly hack so that we can initialize
	 * `out' arrays and array counts to 0 (maybe someday even to a
	 * proper value) prior to calling the work function.  This is
	 * the presentation style of MIG, and thus we must immitate
	 * it.  Note that this is not an optimal solution, since it
	 * indicates to the work function there is no space allocated
	 * for the array, when in fact we should give it some space in
	 * the reply message buffer (or worse, it may already have
	 * space allocated on the stack, in the case of bounded
	 * arrays).  Currently, this can't be handled properly by
	 * Flick.
	 */
	if (!strcmp(which_stub, "server")
	    && !strcmp(alloc->allocator, "auto")
	    /* XXX - no info on director for allocation-only (out) params */
	    && current_param_dir != PRES_C_DIRECTION_IN
	    && current_param_dir != PRES_C_DIRECTION_INOUT
	    && ((ctype && ctype->kind == CAST_TYPE_POINTER) /* an array */
		|| (target_type->kind == CAST_TYPE_NAME /* or a length */
		    && !strcmp(target_type->cast_type_u_u.name,
			       "mach_msg_type_number_t")))) {
		add_stmt(
			cast_new_stmt_expr(
				cast_new_expr_assign_to_zero(
					cast_new_unary_expr(
						CAST_UNARY_DEREF,
						pexpr),
					target_type,
					&(pres->cast))));
	}
}

/* End of file. */

