/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

#include "mach3.h"

void mach3_mu_state::mu_server_func_reply(pres_c_server_func *sfunc,
					  pres_c_server_skel *sstub)
{
	mu_state      *must_out = another(MUST_ENCODE | MUST_DEALLOCATE);
	
	mint_ref       simple_reply_itype;
	pres_c_inline  simple_reply_inline;
	
	/* set the initial maximum message size (for unseen header) */
	((mach3_mu_state *) must_out)->max_msg_size = 32;
	
	/*
	 * Strip away the ``collapsed union'' goo that encodes IDL and
	 * interface information.  We don't need to encode that data for
	 * Mach3MIG IPC because it is manifest in the object (port) references.
	 */
	remove_idl_and_interface_ids(pres,
				     sstub->reply_itype, sfunc->reply_i,
				     &simple_reply_itype, &simple_reply_inline
		);
	/*
	 * Do not call `remove_operation_id' to remove the operation
	 * identifier.  MIG transmits operation reply codes, so we do, too.
	 */
	((mach3_mu_state *) must_out)->set_id_expected(simple_reply_itype);
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name(
				"flick_mach3mig_server_start_encode"),
			0)));
	
	/* Build the reply marshal code. */
	must_out->c_block = c_block;
	must_out->mu_server_func_target(sfunc);
	must_out->mu_server_func_client(sfunc);
	
	must_out->mu_func_params(sfunc->c_func,
				 simple_reply_itype, simple_reply_inline);
	must_out->mu_end();
	
	/*
	 * Move the generated code back into our initial `mu_state' object and
	 * delete the now unneeded `must_out'.
	 */
	c_block = must_out->c_block;
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name("flick_mach3mig_server_end_encode"),
			0)));
	
#if 0
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_assign(
			cast_new_expr_name("_buf_start->Head.msgh_bits"),
			cast_new_expr_name("MACH_MSGH_BITS(19, MACH_MSG_TYPE_MAKE_SEND_ONCE)"))));
#endif
	mach3_mu_state *mout = (mach3_mu_state *)must_out;
	
	if (mout->is_complex == (void *) 1) {
		mout->add_stmt(cast_new_stmt_expr(cast_new_expr_op_assign(
			CAST_BINARY_BOR,
			cast_new_expr_name("_buf_start->Head.msgh_bits"),
			cast_new_expr_name("MACH_MSGH_BITS_COMPLEX"))));
	}
	
	/* Update the maximum message size */
	if (mout->max_msg_size > max_msg_size)
		max_msg_size = mout->max_msg_size;
	
	delete must_out;
}

void w_server_skel(pres_c_1 *pres, int stub_idx)
{
	int assumptions = RPCM_TRUSTED; /* XXX */
	int i;
	
	mint_ref      simple_request_itype;
	pres_c_inline simple_request_inline;
	
	assert(pres);
	
	pres_c_stub *stub = &pres->stubs.stubs_val[stub_idx];
	assert(stub->kind == PRES_C_SERVER_SKEL);
	pres_c_server_skel *sskel = &stub->pres_c_stub_u.sskel;
	assert(sskel->c_def >= 0);
	assert(sskel->c_def < (signed int)pres->cast.cast_scope_len);
	cast_def *cdef = &pres->cast.cast_scope_val[sskel->c_def];
	emergency_return_value = cast_new_expr_name("return 1");
	
	mach3_mu_state must(pres,
			    (MUST_DECODE | MUST_ALLOCATE), assumptions,
			    "server");
	
	/* set the initial maximum message size (for unseen header) */
	must.max_msg_size = 24;
	
	/*
	 * Initialize `simple_request_itype' to the "whole" MINT request type,
	 * so that in case we have no server-side functions, we'll still point
	 * to *some* valid MINT type!
	 */
	simple_request_itype = sskel->request_itype;
	
	/* Build an initial array of decode_cases
	   for the top level of decoding.  */
	decode_switch_case dcase[sskel->funcs.funcs_len];
	for (i = 0; i < (signed int) sskel->funcs.funcs_len; i++) {
		/*
		 * Strip away the ``collapsed union'' goo that encodes IDL and
		 * interface information.  We don't need that information for
		 * Mach3MIG IPC because it is manifest in the object (port)
		 * references.
		 *
		 * The astute reader will note that the function call below
		 * only takes care of half of the problem --- what about the
		 * reply?  The IDL and interface codes are removed from the
		 * reply by a Mach3MIG IPC version of `mu_server_func_reply()'.
		 */
		remove_idl_and_interface_ids(
			pres,
			sskel->request_itype,
			sskel->funcs.funcs_val[i].request_i,
			&simple_request_itype,
			&simple_request_inline);
		
		dcase[i].inl         = simple_request_inline;
		dcase[i].server_func = &sskel->funcs.funcs_val[i];
		dcase[i].server_skel = sskel;
	}
	
	must.set_id_expected(simple_request_itype);
	
	/* Descend through the message union tree,
	   producing switch statements that decode the message into 
	   separate procedures.  */
	must.mu_decode_switch(dcase,
			      sskel->funcs.funcs_len,
			      simple_request_itype);
	
	w_printf("boolean_t %s(mach_msg_header_t *InHeadP, mach_msg_header_t *OutHeadP)\n",
		 cdef->name);
	w_printf("{\n");
	
	if (must.c_block) {
		/* Encoding/decoding buffer-related variables.  */
		w_i_printf(1, "register mig_reply_header_t *_buf_start;\n");
		w_i_printf(1, "register void *_buf_current;\n\n");
		w_i_printf(1, "flick_mach3mig_server_start_decode();\n");
		
		/* Output the complete server dispatcher function.  */
		cast_w_stmt(must.c_block, 1);

		w_i_printf(1, "return 1;\n");
	} else {
		warn("Empty server skeleton!");
		w_i_printf(1, "return 0;\n");
	}
	
	w_printf("}\n");
}

/* End of file. */

