/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include "sun.h"

sun_mu_state::sun_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
:	mem_mu_state(pres, op, assumptions, 2, 0, 8192/*XXX*/, which)
{
	in_packed_array = 0;
}

sun_mu_state::sun_mu_state(const sun_mu_state &must)
:	mem_mu_state(must)
{
	in_packed_array = must.in_packed_array;
}

mu_state *sun_mu_state::another(mu_state_op op)
{
	return new sun_mu_state(pres, op, assumptions, which_stub);
}

mu_state *sun_mu_state::clone()
{
	return new sun_mu_state(*this);
}

void sun_mu_state::get_prim_params(mint_ref itype,
				   int *size, int *align_bits,
				   char **macro_name)
{
	mem_mu_state::get_prim_params(itype, size, align_bits, macro_name);

        mint_def *def = &(pres->mint.defs.defs_val[itype]);

	if (in_packed_array) {
		assert(*size == 1);
		assert(*align_bits == 0);
		*macro_name = flick_asprintf("%s_packed",*macro_name);
		
	} else if ((def->kind == MINT_INTEGER)
		   && (array_def != 0)) {
                /*
                 * We're processing an array length, and we always pad these
                 * out to four bytes.
                 */
                int bits, is_signed;
                
                assert(*size <= 4);
                *size = 4;
                *align_bits = 2;
                
                /* We must recompute the macro name, too. */
                mint_get_int_size(&pres->mint, itype, &bits, &is_signed);
                *macro_name = flick_asprintf("flick_%s_%s_%s%d",
                                             get_encode_name(),
                                             get_buf_name(),
                                             (is_signed ?
                                              "signed" : "unsigned"),
                                             ((*size) * 8));
		
        } else {
		if (*size < 4)
			*size = 4;
		*align_bits = 2;
	}
}

void sun_mu_state::mu_array(
	cast_expr array_expr, cast_type array_ctype,
	pres_c_allocation *array_alloc,
	cast_type elem_ctype, mint_ref elem_itype,
	pres_c_mapping elem_map,
	cast_expr len_expr, cast_type len_ctype,
	unsigned long len_min, unsigned long len_max)
{
	assert(!in_packed_array);

	/*
	 * If we're processing an array whose XDR stream should be packed,
	 * record that.
	 */
	if (len_ctype) /* if an array */ {
		if ((pres->mint.defs.defs_val[elem_itype].kind == MINT_INTEGER)
		    && (pres->mint.defs.defs_val[elem_itype].mint_def_u.
			integer_def.min == -128)
		    && (pres->mint.defs.defs_val[elem_itype].mint_def_u.
			integer_def.range == 255)
			)
			in_packed_array = 1;
		else if ((pres->mint.defs.defs_val[elem_itype].kind
			  == MINT_CHAR)
			 && (pres->mint.defs.defs_val[elem_itype].mint_def_u.
			     char_def.bits == 8)
			)
			in_packed_array = 1;
	}
	
	/* Otherwise process the array normally.  */
	mem_mu_state::mu_array(array_expr, array_ctype, array_alloc,
			       elem_ctype, elem_itype, elem_map,
			       len_expr, len_ctype, len_min, len_max);
	
	/* we need to pad ourselves to a 4-byte boundary */
	/* XXX we still don't fill the padded bytes with zeroes like the 
           sun specification dictates we ought to. */
	if (in_packed_array && ((align_bits < 2) || (align_ofs & 3)))
                chunk_prim(2, 0);
	
	in_packed_array = 0;
}

sun_target_mu_state::sun_target_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
	: target_mu_state(pres, op, assumptions, which)
{
}

sun_target_mu_state::sun_target_mu_state(const sun_target_mu_state &must)
	: target_mu_state(must)
{
}

mu_state *sun_target_mu_state::clone()
{
	return new sun_target_mu_state(*this);
}

char *sun_target_mu_state::get_encode_name()
{
	return "xdr";
}

char *sun_target_mu_state::get_be_name()
{
	return "suntcp";
}

sun_client_mu_state::sun_client_mu_state(pres_c_1 *pres, mu_state_op op, int assumptions, char *which)
	: client_mu_state(pres, op, assumptions, which)
{
}

sun_client_mu_state::sun_client_mu_state(const sun_client_mu_state &must)
	: client_mu_state(must)
{
}

mu_state *sun_client_mu_state::clone()
{
	return new sun_client_mu_state(*this);
}

char *sun_client_mu_state::get_encode_name()
{
	return "xdr";
}

char *sun_client_mu_state::get_be_name()
{
	return "suntcp";
}

char *sun_mu_state::get_be_name()
{
	return "suntcp";
}

char *sun_mu_state::get_encode_name()
{
	return "xdr";
}

void
w_header_includes(pres_c_1 *p)
{
	int prognum = 0x56789abc;

	w_printf("#include <flick/link/suntcp.h>\n");
	w_printf("#include <flick/encode/xdr.h>\n");
	// XXX - This will output any PROGRAM & VERSION macros for use with
	// clnt_create functions.
	// Eventually this should be changed to allow a cmd-line setting for
	// The prognum value.
	for (int i = 0; i < (signed int) p->a.aoi_len; i++) {
		if (p->a.aoi_val[i].binding) {
			if (p->a.aoi_val[i].binding->kind == AOI_INTERFACE) {
				if (p->a.aoi_val[i].binding->aoi_type_u_u.
				    interface_def.idl
				    != AOI_IDL_SUN) {
					w_printf("#define _PROG_%s "
						 "((u_long)%d)\n",
						 p->a.aoi_val[i].name,
						 prognum++);
					w_printf("#define _VERS_%s "
						 "((u_long)1)\n",
						 p->a.aoi_val[i].name);
				}
			}
		}
	}
}

/* End of file. */

