/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

#include "sun.h"

void sun_mu_state::mu_server_func_reply(pres_c_server_func *sfunc, pres_c_server_skel *sskel)
{
	mu_state	*must_out = another(MUST_ENCODE | MUST_DEALLOCATE);
	
	mint_ref	simple_reply_itype;
	pres_c_inline	simple_reply_inline;
	
	/*
	 * Strip away the ``collapsed union'' goo that encodes IDL and
	 * interface information.  We don't need to encode that data in ONC/TCP
	 * reply messages.  Similarly, strip away the ``collapsed union'' goo
	 * that represents the operation's reply code (which is a fixed value
	 * --- NOT an indicator of success or failure).  The client knows what
	 * operation it invoked.
	 */
	remove_idl_and_interface_ids(pres,
				     sskel->reply_itype, sfunc->reply_i,
				     &simple_reply_itype, &simple_reply_inline
		);
	remove_operation_id(pres,
			    simple_reply_itype, simple_reply_inline,
			    &simple_reply_itype, &simple_reply_inline
		);
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name("flick_suntcp_server_start_encode"),
			0)));
	
	/* Build the reply marshal code. */
	must_out->c_block = c_block;
	must_out->mu_server_func_target(sfunc);
	must_out->mu_func_params(sfunc->c_func,
				 simple_reply_itype, simple_reply_inline);
	must_out->mu_end();
	
	/*
	 * Move the generated code back into our initial `mu_state' object and
	 * delete the now unneeded `must_out'.
	 */
	c_block = must_out->c_block;
	delete must_out;
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name("flick_suntcp_server_end_encode"),
			0)));
}

void w_server_skel(pres_c_1 *pres, int stub_idx)
{
	int assumptions = RPCM_TRUSTED; /* XXX */
	mint_ref simple_request_itype;
	pres_c_inline simple_request_inline;
	
	int i;
	
	assert(pres);
	
	pres_c_stub *stub = &pres->stubs.stubs_val[stub_idx];
	assert(stub->kind == PRES_C_SERVER_SKEL);
	pres_c_server_skel *sskel = &stub->pres_c_stub_u.sskel;
	assert(sskel->c_def >= 0); assert(sskel->c_def < (signed int)pres->cast.cast_scope_len);
	cast_def *cdef = &pres->cast.cast_scope_val[sskel->c_def];
	
	/* return SUCCESS since it should send the reply (which has an error)*/
	emergency_return_value = cast_new_expr_name(
		"return FLICK_OPERATION_SUCCESS");
	sun_mu_state must(pres, MUST_DECODE | MUST_ALLOCATE, assumptions, "server");
	
	/*
	 * Initialize `simple_request_itype' to the "whole" MINT request type,
	 * so that in case we have no server-side functions, we'll still point
	 * to *some* valid MINT type!
	 */
	simple_request_itype = sskel->request_itype;
	
	/* Build an initial array of decode_cases
	   for the top level of decoding.  */
	decode_switch_case dcase[sskel->funcs.funcs_len];
	for (i = 0; i < (signed int)sskel->funcs.funcs_len; i++) {
		/*
		 * Strip away the ``collapsed union'' goo that encodes IDL and
		 * interface information.  Our server skeleton does not need to
		 * decode program and version identifiers; this is handled by
		 * Flick's ONC/TCP runtime.
		 *
		 * The astute reader will note that the function call below
		 * only takes care of half of the problem --- what about the
		 * reply?  The IDL and interface codes are removed from the
		 * reply by an ONC/TCP version of `mu_server_func_reply()'.
		 */
		remove_idl_and_interface_ids(
			pres,
			sskel->request_itype,
			sskel->funcs.funcs_val[i].request_i,
			&simple_request_itype,
			&simple_request_inline);
		
		dcase[i].inl         = simple_request_inline;
		dcase[i].server_func = &sskel->funcs.funcs_val[i];
		dcase[i].server_skel = sskel;
	}
	
	/* Descend through the message union tree,
	   producing switch statements that decode the message into 
	   separate procedures.  */
	
	must.mu_decode_switch(dcase, sskel->funcs.funcs_len, simple_request_itype);

	w_printf("flick_operation_success_t %s(FLICK_BUFFER *InHeadP, "
		 "FLICK_BUFFER *OutHeadP)\n",
		 cdef->name);
	w_printf("{\n");

	if (must.c_block) {
		/* Encoding/decoding buffer-related variables.  */
		w_i_printf(1, "FLICK_BUFFER *_stream;\n");
		
		/* Invoke the macro to set up for decoding the received message.  */
		w_i_printf(1, "flick_suntcp_server_start_decode();\n");
		
		/* Output the complete server dispatcher function.  */
		cast_w_stmt(must.c_block, 1);
	} else
		warn("Empty server skeleton!");
	
	w_i_printf(1, "return FLICK_OPERATION_SUCCESS;\n");
	w_printf("}\n");
}

/* End of file. */

