/*
 * Copyright (c) 1995, 1996, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include "trapeze.h"

/* Return statements (generally macros)
   that specify whether or not we need to do bit translation
   I.E. in IIOP, this would return a if(_stream->swap) {/} else {/} for
   decoding for encoding, we never have to swap
   
   The parameter specifies whether to output the if, else or endif
   (0, 1, 2 respectively)
   */

static char *decode_if_text =
	"#if %d /* are we in the swapping decode or non-swapping decode */";
static char *decode_else_text = "#else";
static char *decode_endif_text = "#endif";

static char *encode_if_text = "#if 0 /* We never byte swap on encoding */";
static char *encode_else_text = "#else /* Always bcopy */";
static char *encode_endif_text = "#endif /* alway bcopy */";

static char *if_text = "#if BYTE_ORDER != BIG_ENDIAN";
static char *else_text = "#else /* BIG_ENDIAN - do a bcopy*/";
static char *endif_text = "#endif /* ENDIANness */";

cast_stmt trapeze_mu_state::mu_bit_translation_necessary(int which)
{
	cast_stmt macro = cast_new_stmt(CAST_STMT_TEXT);
	int decode = op & MUST_DECODE;

	if (protocol == TRAPEZE_ONC) switch(which) {
	case 0: // #if LITTLE_ENDIAN then bit translation is neccessary - no bcopy
		macro->cast_stmt_u_u.text = if_text;
		break;
	case 1:
		macro->cast_stmt_u_u.text = else_text;
		break;
	case 2:
		macro->cast_stmt_u_u.text = endif_text;
		break;
	default:
		panic("Invalid value passed to "
		      "mu_bit_translation_necessary\n");
	} else switch (which) {
	case 0: 
		macro->cast_stmt_u_u.text = decode
					    ? flick_asprintf(decode_if_text,
							     should_swap)
					    : encode_if_text;
		break;
	case 1:
		macro->cast_stmt_u_u.text = decode
					    ? decode_else_text
					    : encode_else_text;
		break;
	case 2:
		macro->cast_stmt_u_u.text = decode
					    ? decode_endif_text
					    : encode_endif_text;
		break;
	default:
		panic("Invalid value passed to "
		      "mu_bit_translation_necessary\n");
	}
	return macro;
}


/* This function should return either
   a null expression, if the type is NOT fixed,
   or a sizeof expression for the size of the data structure.
   Specifically, this is used from within mu_array
   to see if the memory layout of
   the data structure is identical to
   the buffer layout.
   
   NOTE:  This does NOT require that
   the bit-wise data layout is correct,
   just that the alignment & padding is OK.
   See mu_bit_translation_necessary for stuff regarding bit translation.
   */
cast_expr trapeze_mu_state::mu_get_sizeof(mint_ref itype_name,
					  cast_type ctype,
					  pres_c_mapping map,
					  int *size,
					  int *align_bits)
{
	if (!((op & MUST_DECODE) && should_swap)) {
		/* the default case is sufficient */
		return mem_mu_state::mu_get_sizeof(itype_name, ctype, map,
						   size, align_bits);
	} else {
		cast_expr res = 0;
		*size = *align_bits = -1;
		return res;
	}
}

/* End of file */
