/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>

#include <mom/compiler.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "trapeze.h"

/*
 * This routine is used to generate a runtime function call to a separate
 * marshal/unmarshal stub, if it is discovered that a PRES_C_MAPPING_STUB node
 * cannot or should not be inlined.  (See `mu_state::mu_mapping_stub'.)
 *
 * XXX --- This mechanism needs a lot more working out.
 */

void trapeze_mu_state::mu_mapping_stub_call(cast_expr expr, cast_type ctype,
					 mint_ref itype, pres_c_mapping map)
{
	char *stub_name;
	int idx;
	
	/*****/
	
	idx = pres_c_find_mu_stub(pres, itype, ctype, map,
				  ((op & MUST_ENCODE) ?
				   PRES_C_MARSHAL_STUB :
				   PRES_C_UNMARSHAL_STUB));
	
	if (idx < 0)
		panic("In `trapeze_mu_state::mu_mapping_stub_call', "
		      "can't find marshal stub.");
	
	idx = pres->stubs.stubs_val[idx].pres_c_stub_u.mstub.c_func;
	if ((should_swap == TRAPEZE_SWAP) && (op & MUST_DECODE))
		stub_name = flick_asprintf("%s_swap",
					   (pres->cast.cast_scope_val[idx].
					    name));
	else
		stub_name = pres->cast.cast_scope_val[idx].name;
	
	cast_expr cex = cast_new_expr_call(cast_new_expr_name(stub_name), 2);
	
	cex->cast_expr_u_u.call.params.params_val[0]
		= cast_new_expr_name("_buf_current");
	cex->cast_expr_u_u.call.params.params_val[1]
		= cast_new_unary_expr(CAST_UNARY_ADDR, expr);
	
	add_stmt(cast_new_stmt_expr(cex));
}

/* End of file. */

