/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>
#include <mom/compiler.h>
#include <mom/c/libcast.h>

#include "trapeze.h"

void trapeze_mu_state::mu_server_func_reply(pres_c_server_func *sfunc,
					    pres_c_server_skel *sskel)
{
	mu_state      *must_out = another(MUST_ENCODE | MUST_DEALLOCATE);
	
	mint_ref       simple_reply_itype;
	pres_c_inline  simple_reply_inline;
	
	/*
	 * Strip away the ``collapsed union'' goo that encodes IDL and
	 * interface information.  We don't need to encode that data for IIOP
	 * reply messages.  Similarly, strip away the ``collapsed union'' goo
	 * that represents the operation's reply code (which is a fixed value
	 * --- NOT an indicator of success or failure).  The client knows what
	 * operation it invoked.
	 */
	remove_idl_and_interface_ids(pres,
				     sskel->reply_itype, sfunc->reply_i,
				     &simple_reply_itype, &simple_reply_inline
		);
	remove_operation_id(pres,
			    simple_reply_itype, simple_reply_inline,
			    &simple_reply_itype, &simple_reply_inline
		);
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name(
				"flick_trapeze_server_start_encode"),
			0)));
	
	/* Build the reply marshal code. */
	must_out->c_block = c_block;
	must_out->mu_server_func_target(sfunc);
	must_out->mu_func_params(sfunc->c_func,
				 simple_reply_itype, simple_reply_inline);
	must_out->mu_end();
	
	/*
	 * Move the generated code back into our initial `mu_state' object and
	 * delete the now unneeded `must_out'.
	 */
	c_block = must_out->c_block;
	delete must_out;
	
	add_stmt(cast_new_stmt_expr(
		cast_new_expr_call(
			cast_new_expr_name("flick_trapeze_server_end_encode"),
			0)));
}

void w_server_skel(pres_c_1 *pres, int stub_idx)
{
	int assumptions = RPCM_TRUSTED; /* XXX */
	mint_ref simple_request_itype;
	pres_c_inline simple_request_inline;
	
	int i;
	
	assert(pres);
	
	pres_c_stub *stub = &pres->stubs.stubs_val[stub_idx];
	assert(stub->kind == PRES_C_SERVER_SKEL);
	pres_c_server_skel *sskel = &stub->pres_c_stub_u.sskel;
	assert(sskel->c_def >= 0);
	assert(sskel->c_def < (signed int)pres->cast.cast_scope_len);
	cast_def *cdef = &pres->cast.cast_scope_val[sskel->c_def];
	
	/*
	 * This emergency_return_value is used in the case of an error.  It
         * is a success value because the error should already be handled,
         * and the server should continue as normal.
	 */
	emergency_return_value =
		cast_new_expr_name("return FLICK_OPERATION_SUCCESS");
	
	trapeze_mu_state must(pres, MUST_DECODE | MUST_ALLOCATE,
			      assumptions, "server", TRAPEZE_NO_SWAP);
	trapeze_mu_state swap_must(pres, MUST_DECODE | MUST_ALLOCATE,
				   assumptions, "server", TRAPEZE_SWAP);
	
	/*
	 * Initialize `simple_request_itype' to the "whole" MINT request type,
	 * so that in case we have no server-side functions, we'll still point
	 * to *some* valid MINT type!
	 */
	simple_request_itype = sskel->request_itype;
	
	/* Build an initial array of decode_cases
	   for the top level of decoding.  */
	decode_switch_case dcase[sskel->funcs.funcs_len];
	for (i = 0; i < (signed int)sskel->funcs.funcs_len; i++) {
		/*
		 * Strip away the ``collapsed union'' goo that encodes IDL and
		 * interface information.  We don't need that information for
		 * IIOP because it is manifest in the object references.
		 *
		 * The astute reader will note that the function call below
		 * only takes care of half of the problem --- what about the
		 * reply?  The IDL and interface codes are removed from the
		 * reply by an IIOP version of `mu_server_func_reply()'.
		 */
		remove_idl_and_interface_ids(
			pres,
			sskel->request_itype,
			sskel->funcs.funcs_val[i].request_i,
			&simple_request_itype,
			&simple_request_inline);
		replace_operation_ids(
			pres,
			simple_request_itype,
			simple_request_inline);
		
		dcase[i].inl         = simple_request_inline;
		dcase[i].server_func = &sskel->funcs.funcs_val[i];
		dcase[i].server_skel = sskel;
	}
	
	/* Descend through the message union tree,
	   producing switch statements that decode the message into 
	   separate procedures.  */
	
	must.mu_decode_switch(dcase, sskel->funcs.funcs_len,
			      simple_request_itype);
	swap_must.mu_decode_switch(dcase, sskel->funcs.funcs_len,
				   simple_request_itype);
	
	w_printf("flick_operation_success_t %s(FLICK_BUFFER _msg_buf, "
		 "caddr_t _buf_start, FLICK_CLIENT _this_obj)\n",
		 cdef->name);
	w_printf("{\n");

	if (swap_must.c_block && must.c_block) {
		/* Encoding/decoding buffer-related variables.  */
		w_i_printf(1, "register void *_buf_current;\n");
		
		/* Reply token holder */
		w_i_printf(1, "tpz_msgspec_t  _replytoken;\n");

		/* Invoke the macro to set up for decoding the
		   received message.  */
		w_i_printf(1, "flick_%s_server_start_decode();\n",
			   must.get_be_name());
	
		// We need to if (swap) the remaining stuff...
//		w_i_printf(1, "if (flick_cdr_swap()) {\n");
		
		/* Output the complete swapped server dispatcher function.  */
//		cast_w_stmt(swap_must.c_block, 1);
		
//		w_i_printf(1, "} else {\n");
		
		/* Output the complete server dispatcher function.  */
		cast_w_stmt(must.c_block, 1);	
//		w_i_printf(1, "}\n");
		w_i_printf(1, "return FLICK_OPERATION_SUCCESS;\n");
	} else {
		w_i_printf(1, "return FLICK_OPERATION_FAILURE;\n");
		warn("Empty server skeleton!");
	}
	w_printf("}\n");
}
	
/* End of file. */

