/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _trapeze_h

#include <mom/c/pbe_mem.hh>
#include <mom/c/pbe_target.hh>
#include <mom/c/pbe_client.hh>
#define TRAPEZE_NO_SWAP 0
#define TRAPEZE_SWAP 1

#define TRAPEZE_MAX_CONTROL_SIZE  112
#define TRAPEZE_MAX_PAYLOAD_SIZE 8192

typedef enum {
	TRAPEZE,
	TRAPEZE_ONC
} trapeze_protocol_t;

struct trapeze_mu_state : public mem_mu_state
{
	// This is whether or not the code should byteswap
	int should_swap;
	cast_expr has_payload;
	trapeze_protocol_t protocol;
	
	trapeze_mu_state(pres_c_1 *_pres, 
		      mu_state_op _op, 
		      int _assumptions, 
		      char *which, 
		      int swap = TRAPEZE_NO_SWAP);
  
	trapeze_mu_state(const trapeze_mu_state &must);
	mu_state *clone();
	mu_state *another(mu_state_op op);

	virtual char *get_be_name();
	virtual char *get_encode_name();
	virtual int get_most_packable()
	{
		return 4;
	}
	
	virtual void get_prim_params(mint_ref itype, int *size,
				     int *align_bits, char **macro_name);

	virtual void mu_server_func_reply(pres_c_server_func *sfunc,
					  pres_c_server_skel *sskel);
	
	virtual target_mu_state *mu_make_target_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
	virtual client_mu_state *mu_make_client_mu_state(pres_c_1 *pres,
							 mu_state_op op,
							 int assumptions,
							 char *which);
	
	/* This returns nil, if it's not a fixed size,
	   or a sizeof call otherwise */
	virtual cast_expr mu_get_sizeof(mint_ref itype,
					cast_type ctype,
					pres_c_mapping map,
					int *size,
					int *align_bits);
  
	/* This returns a #if (0), #else (1), or #endif (2)
	   for bit-translation checking */
	virtual cast_stmt mu_bit_translation_necessary(int);
	virtual void mu_prefix_params();
	
	virtual void mu_mapping_stub_call(cast_expr expr, cast_type ctype,
					  mint_ref itype, pres_c_mapping map);
	
	/* This is used for passing object references other than
	   the self reference */
	virtual void mu_mapping_reference(cast_expr expr, cast_type ctype,
					  mint_ref itype,
					  pres_c_mapping_reference *rmap);
	
	virtual void mu_array(
		cast_expr array_expr,
		cast_type array_ctype,
		pres_c_allocation *array_alloc,
		cast_type elem_ctype,
		mint_ref elem_itype,
		pres_c_mapping elem_map,
		cast_expr len_expr, cast_type len_ctype,
		unsigned long len_min, unsigned long len_max);
	
	virtual void mu_mapping_string(cast_expr ptr,
				       cast_type ptr_ctype,
				       mint_array_def *arr,
				       pres_c_allocation *mem_alloc);
	
	virtual void mu_server_func(pres_c_inline inl, mint_ref tn_r,
				    pres_c_server_func *sfunc,
				    pres_c_server_skel *sskel);
	
	virtual void mu_mapping_system_exception(cast_expr expr,
						 cast_type ctype,
						 mint_ref itype);

};

struct trapeze_target_mu_state : public target_mu_state
{
	trapeze_protocol_t protocol;

	trapeze_target_mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions, char *which);
	trapeze_target_mu_state(const trapeze_target_mu_state &must);
	virtual mu_state *clone(); 
	virtual char *get_be_name();
	virtual char *get_encode_name();
};

struct trapeze_client_mu_state : public client_mu_state
{
	trapeze_client_mu_state(pres_c_1 *_pres, mu_state_op _op, int _assumptions, char *which);
	trapeze_client_mu_state(const trapeze_client_mu_state &must);
	virtual mu_state *clone(); 
	virtual char *get_be_name();
	virtual char *get_encode_name();
};

void replace_operation_ids(pres_c_1 *pres,
			   mint_ref itype,
			   pres_c_inline inl);

trapeze_protocol_t what_protocol(pres_c_1 *pres);

#endif _trapeze_h

/* End of file. */

