/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/c/libpres_c.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/compiler.h>

#include "pg_fluke.hh"

void pg_fluke::p_scalar(int bits, int is_signed,
			cast_type *out_ctype, pres_c_mapping *out_map)
{
	char *name;
	cast_primitive_kind kind;
	cast_primitive_modifier mod;

	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
	
	switch (bits) {
	case 1:
		/* `oskit_bool_t' may or may not be a 32-bit integer. */
		*out_ctype = cast_new_type_name("oskit_bool_t");
		return;
	case 8:
		kind = CAST_PRIM_CHAR;
		mod = CAST_MOD_UNSIGNED;
		break;
	case 16:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 32:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 64:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG_LONG | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	default:
		panic("unknown number of int bits - %d", bits);
	}
	
	assert(bits == 8 || bits == 16 || bits == 32 || bits == 64);
	name = flick_asprintf("oskit_%c%d_t",
			      (is_signed ? 's' : 'u'),
			      bits);
	*out_ctype = cast_new_prim_alias(kind, mod, name);
}

void pg_fluke::p_float_type(aoi_float *ai,
			    cast_type *out_ctype, pres_c_mapping *out_map)
{
	// Avoid the CORBA remapping of float types
	pg_state::p_float_type(ai, out_ctype, out_map);
}

void pg_fluke::p_char_type(aoi_char *ac,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	// Avoid the CORBA remapping of char types
	pg_state::p_char_type(ac, out_ctype, out_map);
}

/* End of file. */

