/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>

#include "pg_fluke.hh"

void pg_fluke::p_enum_type(aoi_enum *ae,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	/* Do the usual CORBA thing... */
	pg_corba::p_enum_type(ae, out_ctype, out_map);
	
	/* ...but change the base type from `CORBA_enum' to `unsigned long'. */
	*out_ctype = cast_new_prim_type(CAST_PRIM_INT,
					(CAST_MOD_UNSIGNED | CAST_MOD_LONG));
}

/* End of file. */

