/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/c/libpres_c.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/compiler.h>

#include "pg_l4.hh"

void pg_l4::p_scalar(int bits, int is_signed,
			cast_type *out_ctype, pres_c_mapping *out_map)
{
	char *name;
	cast_primitive_kind kind;
	cast_primitive_modifier mod;

	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
	
	switch (bits) {
	case 1:
  	        kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT1 | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 2:
  	        kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT2 | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 4:
  	        kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT4 | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 8:
		kind = CAST_PRIM_CHAR;
		mod = CAST_MOD_UNSIGNED;
		break;
	case 16:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 32:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	case 64:
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG_LONG | (is_signed ? 0 : CAST_MOD_UNSIGNED);
		break;
	default:
		panic("unknown number of int bits - %d", bits);
	}
	
	// (1, 2, 4, 8, 16, 32, 64)
	assert((!(bits % 2) || (bits==1)) && bits <= 64);

	switch (bits) {
	case 1:
	    name = flick_asprintf(is_signed ? "sbyte1_t" : "byte1_t"); break;
	case 2:
	    name = flick_asprintf(is_signed ? "sbyte2_t" : "byte2_t"); break;
	case 4:
	    name = flick_asprintf(is_signed ? "sbyte4_t" : "byte4_t"); break;
	case 8:
	    name = flick_asprintf(is_signed ? "sbyte_t" : "byte_t"); break;
	case 16:
	    name = flick_asprintf(is_signed ? "sword_t" : "word_t"); break;
	case 32:
	    name = flick_asprintf(is_signed ? "sdword_t" : "dword_t"); break;
	case 64:
	    name = flick_asprintf(is_signed ? "sqword_t": "qword_t"); break;
	}

	*out_ctype = cast_new_prim_alias(kind, mod, name);
}

void pg_l4::p_float_type(aoi_float *ai,
			    cast_type *out_ctype, pres_c_mapping *out_map)
{
	// Avoid the CORBA remapping of float types
	pg_state::p_float_type(ai, out_ctype, out_map);
}

void pg_l4::p_char_type(aoi_char *ac,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	// Avoid the CORBA remapping of char types
	pg_state::p_char_type(ac, out_ctype, out_map);
}

/* End of file. */

