/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include <string.h>

#include "pg_l4.hh"

/*
 * In L4, server-side target objects are represented by application-defined
 * structures.  (A target object is an object upon which an operation is being
 * invoked.)  Server work functions receive pointers to these structures.
 * Object references passed as parameters are presented as `mom_ref_t's, as
 * determined by `pg_l4::p_indirect_type'.
 *
 * On the client side, all object references are presented as `mom_ref_t's.
 * When we are generating a client presentation, we never get to the method
 * below because `pg_l4::p_typedef_def' screens out client-side interface
 * typedefs.
 */

void pg_l4::p_forward_type(cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_type  struct_type = cast_new_type(CAST_TYPE_STRUCT_NAME);
	
	struct_type->cast_type_u_u.struct_name =
		calc_server_basic_object_type_name(a(cur_aoi_idx).name);
	
	*out_ctype = struct_type;
	*out_map   = pres_c_new_mapping(PRES_C_MAPPING_IGNORE); /* XXX! */
	/*
	 * `PRES_C_MAPPING_IGNORE' is okay for now because the L4 back end
	 * never tries to marshal or unmarshal a target object reference.
	 * However, the mapping style is bad news for any back end that *does*
	 * need to marshal/unmarshal target object references.
	 */
}

/* End of file. */

