/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/pfe.hh>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "pg_l4.hh"

void pg_l4::p_marshal_stub_conn(pres_c_marshal_stub *mstub)
{
	cast_func_type *cfunc = &c(mstub->c_func).u.cast_def_u_u.func_type;
	struct cast_field *cfield;
	int p;
	
	pres_c_mapping conn_ref_map;
	
	/* Build a C parameter in cfunc->params.params_val[p] that refers to
	   the marshal/unmarshal stream.  Note that the type of the `_stream'
	   argument is `flick_marshal_stream'.  This is an abstract type that
	   will be implemented by the runtime associated with the transport
	   that is eventually chosen.
	   
	   NOTE: It is an extremely bad idea to specialize this method within a
	   particular presentation generator.  If you do so (e.g., to change
	   the type of the `_stream' argument), then your new presentation
	   generator will produce code that can't be used with Flick's runtime
	   libraries.
	   
	   At one time, I thought that it would be a good idea to change the
	   type of `_stream' to be a C pointer.  This is actually a *bad* idea
	   because it constrains the possible ways in which the Flick runtimes
	   can implement streams.  A runtime might implement want to implement
	   `flick_marshal_stream_t' an an integer index into an array of
	   structres, for example.
	   
	   The only restriction that we impose here on the implementation of
	   `flick_marshal_stream_t' is that streams must be passable by value
	   to marshal and unmarshal functions.  Practically, this means that
	   `flick_marshal_stream_t' must be some kind of pointer or index to a
	   structure, but we don't *force* a choice by making `_stream' be a
	   pointer. */
	p = cast_func_add_param(cfunc);
	cfield = &cfunc->params.params_val[p];
	cfield->name = "_ipc_buffer";
	cfield->type = cast_new_type_name("flick_l4_ipc_buffer_t *");
	
	/* Make a reference mapping for the `cfield'. */
	/*
	 * XXX --- The `target_i' field for a marshal/unmarshal stub seems to
	 * be obsolete --- perhaps it is a holdover from some past time when
	 * m/u stubs received target object references?  Or was it simply
	 * intended to be a way to find the marshal stream argument (through
	 * the inline atom index `p')?
	 *
	 * In either case, `cfield' does not now refer to an object reference,
	 * so it is wrong to make a PRES_C_MAPPING_REFERENCE for it.  Let's
	 * make a PRES_C_MAPPING_IGNORE instead.
	 */
	conn_ref_map = pres_c_new_mapping(PRES_C_MAPPING_IGNORE);
	
	/* Finally, set the target inline (`target_i') for this stub.  The
           appropriate inline is an inline atom. */
	mstub->target_i = pres_c_new_inline_atom(p, conn_ref_map);
}
/* End of file. */



