/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>
#include <stdlib.h>

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/libmint.h>
#include <mom/c/pfe.hh>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"
#include "pg_l4.hh"

#define FLICK_SERVER_TYPE_NAME "int"

/* Generate server skeleton stub presentation for an AOI interface. */
void pg_l4::p_server_skel(aoi_interface * /*ai*/)
{
	pres_c_server_skel *sskel;
	char *sskel_name;
	int sskel_index;
	
	aoi_ref saved_parent_ref, saved_derived_ref;
	
	/* Save the original name context for when we return. */
	char *old_name = name;
	name = FLICK_SERVER_TYPE_NAME;
	
	/*
	 * Set the `pg_state' interface reference data members to point at the
	 * interfaces under consideration so that `pg_state::calc_name' can
	 * compute names.
	 */
	saved_parent_ref = parent_interface_ref;
	saved_derived_ref = derived_interface_ref;
	
	parent_interface_ref = cur_aoi_idx;
	derived_interface_ref = cur_aoi_idx;
	
	/* Allocate a PRES_C_STUB for this interface. */
	sskel_index = p_add_stub(out_pres);
	s(sskel_index).kind = PRES_C_SERVER_SKEL;
	sskel = &s(sskel_index).pres_c_stub_u.sskel;
	
	/*
	 * Prepare the skeleton name.
	 */
	sskel_name = calc_server_skel_name("");

	/*
	 * Set `sskel->c_def' to the C declaration for this server skeleton.
	 */
	sskel->c_def = p_server_skel_cdef(sskel_name);

	out_pres->cast.cast_scope_val[sskel->c_def].included = a(cur_aoi_idx).
							       included;
	
	/*
	 * Set `sskel->request_itype' and `sskel->reply_itype' to the top-level
	 * MINT message union.
	 */
	sskel->request_itype = top_union;
	sskel->reply_itype = top_union;
	
	/*
	 * Restore the name context BEFORE we try to build the PRES_C for any
	 * server functions.
	 */
	name = sskel_name;
	
	/* Generate presentations for the server functions. */
	sskel->funcs.funcs_len = 0;
	sskel->funcs.funcs_val = 0;
	p_server_skel_internal(cur_aoi_idx, cur_aoi_idx, sskel);
	
	name = old_name;
	
	/*
	 * Finally, restore the `pg_l4' AOI interface references that we
	 * changed previously.
	 */
	parent_interface_ref = saved_parent_ref;	  
	derived_interface_ref = saved_derived_ref;	  
}



/***** Auxiliary functions. *****/

/*
 * `p_server_skel_cdef' allocates and returns an index to the CAST declaration
 * of a server skeleton (a.k.a. a server dispatch function).
 */
cast_ref pg_l4::p_server_skel_cdef(char *sskel_name)
{
	cast_ref  sskel_cref = cast_add_def(&(out_pres->cast));
	cast_def *sskel_cdef = &(out_pres->cast.cast_scope_val[sskel_cref]);
	cast_func_param *param;

	/* this is the function def. in the header file */
	sskel_cdef->name = sskel_name;
	sskel_cdef->sc = CAST_SC_EXTERN;
	sskel_cdef->u.kind = CAST_FUNC_DECL;
	sskel_cdef->u.cast_def_u_u.func_type.return_type =
		cast_new_type_name(FLICK_SERVER_TYPE_NAME);
	sskel_cdef->u.cast_def_u_u.func_type.params.params_len = 1;

	/* we need a parameter */
	param = sskel_cdef->u.cast_def_u_u.func_type.params.params_val = 
	    (cast_func_param *) mustcalloc(sizeof(cast_func_param));
	param[0].name = calc_server_func_object_param_name("");
	param[0].type = (cast_type_u*)mustcalloc(sizeof(cast_type_u));

	/* and since we want to pass by reference - it's a 
	 * pointer to our parameter
	 */
	param[0].type->kind = CAST_TYPE_POINTER;
	param[0].type->cast_type_u_u.pointer_type.target = (cast_type_u*)mustcalloc(sizeof(cast_type_u));
	param[0].type->cast_type_u_u.pointer_type.target->kind = CAST_TYPE_NAME;
	param[0].type->cast_type_u_u.pointer_type.target->cast_type_u_u.name = calc_server_func_object_type_name(""); 


	return sskel_cref;
}

/* End of file. */

