/*
 * Copyright (c) 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#ifndef _pg_l4_hh
#define _pg_l4_hh

#include <mom/c/pg_corba.hh>

extern "C" 
{
	mint_const build_op_const(aoi_interface *this_interface,
				  char *this_interface_name,
				  aoi_interface *derived_interface,
				  char *derived_interface_name,
				  aoi_operation *op,
				  int type_of_constant);
	
	mint_const build_exception_const_int(aoi_ref exception_ref,
					     unsigned int exception_num);

	void set_namespace(char* name_space);

};

class pg_l4 : public pg_corba {
protected:
	/*
	 * `fdev_seq_type_name' is the presented name of the ``magic'' sequence
	 * type that is handled specially by the L4 `p_variable_array_type'.
	 * See that function for more info.
	 *
	 * `fdev_seq_alloc_name' is the name of the allocator used for
	 * instances of the type named by `fdev_seq_type_name'.
	 *
	 * `fdev_seq_alloc_header' is the name of the `#include' file that
	 * contains the prototypes for the special allocator functions.
	 *
	 * XXX --- These exist for the benefit of a special presentation hack.
	 * When we get a real presentation modification facility, these special
	 * values can go away.
	 */
	static const char * const fdev_seq_type_name = "l4_fdev_seq_octet";
	static const char * const fdev_seq_alloc_name = "fdev";
	static const char * const fdev_seq_alloc_header
						   = "l4/sac/fdev_flick.h";
	
public:
	pg_l4();
	
	/*****/
	
	virtual void      p_typedef_def(aoi_type at);
	virtual cast_type p_make_ctypename(aoi_ref ref);
	
	virtual void p_scalar(int bits, int is_signed, cast_type *out_ctype,
			      pres_c_mapping *out_map);
	virtual void p_float_type(aoi_float *ai, cast_type *out_ctype,
				  pres_c_mapping *out_map);
	virtual void p_char_type(aoi_char *ac, cast_type *out_ctype,
				 pres_c_mapping *out_map);
	virtual void p_enum_type(aoi_enum *ae, cast_type *out_ctype,
				 pres_c_mapping *out_map);
	virtual void p_except_type(aoi_exception *as, cast_type *out_ctype,
				   pres_c_mapping *out_map);
	virtual void p_interface_type(aoi_interface *ai,
				      cast_type *out_ctype,
				      pres_c_mapping *out_map);
	
	virtual void p_forward_type(cast_type *out_ctype,
				    pres_c_mapping *out_map);
	
	virtual void p_indirect_type(aoi_ref ref,
				     cast_type *out_ctype,
				     pres_c_mapping *out_map);
	
	virtual void p_variable_array_type(aoi_array *,
					   cast_type *, pres_c_mapping *);
	
	virtual cast_type p_get_env_struct_type();
	virtual int p_get_exception_discrim();
	cast_expr p_mint_exception_id_const_to_cast(mint_const mint_literal);
	virtual int p_get_exception_void();
	virtual pres_c_inline_atom p_get_user_discrim();
	virtual void p_do_return_union(aoi_operation *ao,
				       pres_c_inline* reply_l4_inl,
				       mint_ref reply_ref,
				       cast_ref cfunc);
		
	/*****/
	
	virtual void p_param_type(aoi_type at, int mr,
				  aoi_direction dir,
				  cast_type *out_ctype,
				  pres_c_mapping *out_mapping);
	
	/*****/
	
	virtual void p_client_stub_special_params(aoi_operation *ao,
						  stub_special_params *s);
	virtual void p_client_stub_prop_special_params(aoi_operation *ao,
						       stub_special_params *s);
	virtual void p_server_func_special_params(aoi_operation *ao,
						  stub_special_params *s);

	virtual void p_client_stub(aoi_interface *ai, aoi_operation *ao);
	virtual void p_client_stub_propagate(aoi_interface *ai, 
					     aoi_operation *ao);
	virtual void p_client_stubs_internal(aoi_ref this_ref,
					     aoi_ref derived_ref);
	
	/*****/
	
	virtual void preprocess();

	/*****/

        virtual void p_marshal_stub_conn(pres_c_marshal_stub *mstub);

	/*****/

	virtual void p_server_skel(aoi_interface *a);
	virtual cast_ref p_server_skel_cdef(char *sskel_name);

	/*****/

	virtual void process_client_prop_params(cast_func_type *cfunc,
						stub_special_params *specials,
						mint_ref request_ref, 
						mint_ref reply_ref,
						aoi_operation *ao,
						pres_c_inline request_l4_inl, 
						pres_c_inline reply_l4_inl);


};

#endif // _pg_l4_hh

/* End of file. */

