/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>

#include <mom/compiler.h>
#include <mom/libaoi.h>		/* For `void_d'. */
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include <mom/c/pfe.hh>
#include "pg_l4.hh"


void pg_l4::process_client_prop_params(
	cast_func_type *cfunc,
	stub_special_params *specials,
	mint_ref request_ref, mint_ref reply_ref,
	aoi_operation *ao,
	pres_c_inline request_l4_inl, pres_c_inline reply_l4_inl)
{
	/*
	 * Process each parameter.
	 *
	 * `aoi_index' is the index into the (input) AOI list of parameters;
	 * `cast_index' is the index into the (output) CAST list of parameters.
	 *
	 * XXX --- This code makes two assumptions: (1) that the order of the
	 * slots in the request and reply MINT types corresponds to the order
	 * of the `in/inout' and `out/inout' parameters (respectively) of the
	 * AOI operation; and (2) that in the request and reply MINT structure
	 * types, there is exactly one slot for each appropriate AOI parameter
	 * (one request slot per `in/inout' parameter, and one reply slot per
	 * `out/inout' parameter).
	 *
	 * Are either of these assumptions bad?  They do mean that the AOI and
	 * MINT must be in very close correspondence.  Maybe we shouldn't
	 * assume so much behavior from the AOI-to-MINT translator.
	 *
	 * XXX --- Certain other code makes assumptions about correspondences
	 * between MINT and PRES_C.  See `pg_state::p_param_client_sid' for a
	 * long diatribe on this subject.
	 */
	int req_idx = 0, rep_idx = 0;
	int cast_params_len = cfunc->params.params_len;
	int aoi_index;
	int cast_index;
	
	for (aoi_index = 0, cast_index = 0;
	     cast_index < cast_params_len;
	     ++cast_index) {
		if (cast_index ==
		    (specials->
		     params[stub_special_params::object_ref].
		     index)) {
			/* This is the object reference parameter. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::object_ref].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::object_ref].
				ctype;
			
		} else if (cast_index ==
			   (specials->
			    params[stub_special_params::environment_ref].
			    index)) {
			/* This is the environment reference parameter. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::environment_ref].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::environment_ref].
				ctype;
			
		} else if (cast_index ==
			   (specials->
			    params[stub_special_params::client_sid].
			    index)) {
			/* This is the client SID parameter. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::client_sid].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::client_sid].
				ctype;
			p_param_client_sid(cast_index, request_l4_inl);
			
		} else if (cast_index ==
			   (specials->
			    params[stub_special_params::required_server_sid].
			    index)) {
			/* This is the required server SID parameter. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::
				      required_server_sid].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::
				      required_server_sid].
				ctype;
			p_param_required_server_sid(cast_index,
						    request_l4_inl);
			
		} else if (cast_index ==
			   (specials->
			    params[stub_special_params::actual_server_sid].
			    index)) {
			/* This is the actual server SID parameter. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::actual_server_sid].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::actual_server_sid].
				ctype;
			p_param_actual_server_sid(cast_index, reply_l4_inl);

		} else if (cast_index ==
			   (specials->
			    params[stub_special_params::rcv_fpage_desc].
			    index)) {
			/* volkmar: This is the fpage-rcv-descriptor. */
			cfunc->params.params_val[cast_index].name =
				specials->
				params[stub_special_params::rcv_fpage_desc].
				name;
			cfunc->params.params_val[cast_index].type =
				specials->
				params[stub_special_params::rcv_fpage_desc].
				ctype;
			
		} else {
			/* This is a normal parameter. */
			mint_ref m_ref;

			//ao->params.params_val[aoi_index].direction=AOI_DIR_IN;

			aoi_direction dir = ao->params.params_val[aoi_index].
					    direction;
			
			/* Get the MINT type of this parameter. */
			if (dir == AOI_DIR_OUT) {
#if 0
				printf("dropped: %s\n", 
				       ao->params.params_val[aoi_index].name);

				aoi_index++;
				cast_index--;
				cast_params_len--;
				continue;
#endif
				/*
				 * KBF - This is now in a UNION before the
				 * structure.
				 *
				 * XXX --- The `0' below is the index of the
				 * ``no-exception reply'' variant.  It should
				 * not be hardcoded.
				 */
				m_ref = m(reply_ref).mint_def_u.union_def.
					cases.cases_val[0].var;
				m_ref = m(m_ref).mint_def_u.struct_def.slots.
					slots_val[rep_idx];
			} else
				m_ref = m(request_ref).mint_def_u.struct_def.
					slots.slots_val[req_idx];
			
			cfunc->params.params_val[cast_index] =
				p_param(&(ao->params.params_val[aoi_index]),
					cast_index, m_ref,
					request_l4_inl, reply_l4_inl,
					req_idx, rep_idx);
			
			req_idx += ((dir == AOI_DIR_INOUT)
				    || (dir == AOI_DIR_IN));
			rep_idx += ((dir == AOI_DIR_INOUT)
				    || (dir == AOI_DIR_OUT));
			
			++aoi_index;
		}
	}
	//cfunc->params.params_len = cast_params_len;
}









