/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>

#include "private.hh"


void pg_state::gen()
{
	/* Initialize the interface table. */
	p_interface_table_clear();
	
	// First, let's allows any prepended CAST to be built
	build_init_cast();
	
	/* The first question is which interface defs we want presentations for.
	   Current answer: all named interface defs.
	   Later, maybe there'll be a way to get better control.
	   (For example, to get a presentation of an unnamed idef.)  */

	/* Do this in two passes.  Leave interface defs for the second pass. */
	
	for (cur_aoi_idx = 0;
	     cur_aoi_idx < ((aoi_ref) in_aoi->aoi_len);
	     ++cur_aoi_idx) {
		name = getscopedname(cur_aoi_idx);
		
		/* Convert it to a C definition. */
		assert(a(cur_aoi_idx).binding);
		if ((a(cur_aoi_idx).binding->kind != AOI_INTERFACE) &&
		    !a(cur_aoi_idx).scope)
			p_def(a(cur_aoi_idx).binding);
	}
	
	for (cur_aoi_idx = 0;
	     cur_aoi_idx < ((aoi_ref) in_aoi->aoi_len);
	     ++cur_aoi_idx) {
		name = getscopedname(cur_aoi_idx);
		
		/* Convert it to a C definition. */
		assert(a(cur_aoi_idx).binding);
		if ((a(cur_aoi_idx).binding->kind == AOI_INTERFACE) &&
		    !a(cur_aoi_idx).scope)
			p_def(a(cur_aoi_idx).binding);
	}
}

/* End of file. */

