/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>

#include "private.hh"

void pg_state::p_char_type(aoi_char *ac,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_primitive_modifier mod;
	
	assert(ac->bits == 8); /* XXX */
	
	if (ac->flags == AOI_CHAR_FLAG_NONE)
		mod = 0;
	else if (ac->flags == AOI_CHAR_FLAG_SIGNED)
		mod = CAST_MOD_SIGNED;
	else if (ac->flags == AOI_CHAR_FLAG_UNSIGNED)
		mod = CAST_MOD_UNSIGNED;
	else
		panic("unrecognized aoi_char flags in pg_state::p_char_type");
	
	*out_ctype = cast_new_prim_type(CAST_PRIM_CHAR, mod);
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}

