/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

// this builds a '#define' statement for the constant mapping
void pg_state::p_const_def(aoi_const ac)
{
	/* Define the C type with a #define statement. */
	int cdef = cast_add_def(&out_pres->cast);
	
	c(cdef).name = calc_const_name(a(cur_aoi_idx).name);
	c(cdef).sc = CAST_SC_NONE;
	c(cdef).u.kind = CAST_DEFINE;
       	c(cdef).u.cast_def_u_u.define_as = p_const_translate(ac);
}

cast_expr pg_state::p_const_translate(aoi_const ac)
{
	cast_expr res;
	
	res = (cast_expr) mustcalloc(sizeof(cast_expr_u));
	
	switch(ac->kind) {
	case AOI_CONST_INT:
		res = cast_new_expr_lit_int(ac->aoi_const_u_u.const_int,
					    (CAST_MOD_SIGNED | CAST_MOD_LONG));
		break;
		
	case AOI_CONST_CHAR:
		res = cast_new_expr_lit_char(ac->aoi_const_u_u.const_char,
					     CAST_MOD_SIGNED);
		break;
		
	case AOI_CONST_FLOAT:
		res = cast_new_expr_lit_float(ac->aoi_const_u_u.const_float);
		break;
		
	case AOI_CONST_ARRAY: {
		/* XXX Currently, this code can handle strings. */
		aoi_const_array array = ac->aoi_const_u_u.const_array;
		int len = ac->aoi_const_u_u.const_array.aoi_const_array_len;
		int pos;
		char *thename;
		
		/* AOI_CONST_ARRAY's are not NUL terminated, so we must add one
		   to the array length for malloc. */
		thename = (char *) mustmalloc(sizeof(char) * (len + 1));
		for (pos = 0; pos < len; ++pos) {
			if (array.aoi_const_array_val[pos]->kind !=
			    AOI_CONST_CHAR)
				panic("Unable to translate const array element of type %d.\n",
				      array.aoi_const_array_val[pos]->kind);
			thename[pos] = array.aoi_const_array_val[pos]->
				       aoi_const_u_u.const_char;
		}
		thename[len] = 0;
		res = cast_new_expr_lit_string(thename);
		break;
	}
	
	case AOI_CONST_STRUCT:
		panic("Don't know how to deal with constant structures!\n");
		break;
		
	default:
		panic("Unknown AOI_CONST type %d\n",ac->kind);
		break;
	}
	
	return res;
}

/* End of file. */

