/*
 * Copyright (c) 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>

#include <mom/c/libcast.h>

#include <mom/c/pfe.hh>

void pg_state::p_emit_include_stmt(char *filename, int system_only)
{
	u_int i;
	
	/*
	 * Check the output CAST to see if we have already output the desired
	 * `#include' statement.  If so, just return.
	 */
	for (i = 0; i < out_pres->cast.cast_scope_len; ++i)
		if ((c(i).u.kind == CAST_INCLUDE)
		    && !strcmp(filename, c(i).u.cast_def_u_u.include.filename)
		    && (c(i).u.cast_def_u_u.include.system_only
			== system_only))
			return;
	
	/* Otherwise... */
	i = cast_add_def(&(out_pres->cast));
	
	c(i).name = "";
	c(i).sc = CAST_SC_NONE;
	c(i).u.kind = CAST_INCLUDE;
	c(i).u.cast_def_u_u.include.filename = filename;
	c(i).u.cast_def_u_u.include.system_only = system_only;
}

/* End of file. */

