/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

void pg_state::p_enum_type(aoi_enum *ae,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_type ctype;
	pres_c_mapping map;
	cast_enum_type *et;
	
	int curval;
	
	/*****/
	
	ctype = cast_new_type(CAST_TYPE_ENUM);
	
	et = &(ctype->cast_type_u_u.enum_type);
	
	et->name = calc_enum_tag_name(ae->enum_label);
	
	et->slots.slots_len = ae->defs.defs_len;
	et->slots.slots_val = (cast_enum_field *)
			      mustmalloc(sizeof(cast_enum_field)
					 * ae->defs.defs_len);
	
	curval = 0;
	for (unsigned int i = 0; i < et->slots.slots_len; i++) {
		et->slots.slots_val[i].name =
			calc_enum_member_name(ae->defs.defs_val[i].name);
		
		if (ae->defs.defs_val[i].type->kind != AOI_CONST)
			et->slots.slots_val[i].val =
				cast_new_expr_lit_int(curval,
						      (CAST_MOD_SIGNED
						       | CAST_MOD_LONG));
		else {
			et->slots.slots_val[i].val =
				p_const_translate(ae->defs.defs_val[i].type->
						  aoi_type_u_u.const_def);
			curval = ae->defs.defs_val[i].type->
				 aoi_type_u_u.const_def->aoi_const_u_u.
				 const_int;
		}
		curval++;
	}
	
	map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
	
	*out_ctype = ctype;
	*out_map = map;
}

/* End of file. */

