/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

void pg_state::p_except_type(aoi_exception *ae, cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_type ctype = cast_new_struct_type(0);
	ctype->cast_type_u_u.struct_type.name = name;

	pres_c_mapping map = pres_c_new_mapping(PRES_C_MAPPING_STRUCT);
	map->pres_c_mapping_u_u.struct_i = p_inline_exception(ae, ctype);

	*out_ctype = ctype;
	*out_map = map;
}

/* Given a MINT constant that refers to an exception id, this function
   creates and returns a corresponding CAST expression.  The default is
   to convert it's value directly. */
cast_expr pg_state::p_mint_exception_id_const_to_cast(mint_const mint_literal)
{
	return p_mint_const_to_cast(mint_literal);
}

