/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

void pg_state::p_fixed_array_type(aoi_array *aa,
				  cast_type *out_ctype,
				  pres_c_mapping *out_map)
{
	/* Create the ctype and mapping for the array's target. */
	cast_type to_ctype;
	pres_c_mapping to_map;
	
	p_type(aa->element_type, &to_ctype, &to_map);
	
	/* Find the length of the array. */
	unsigned length;
	aoi_get_array_len(in_aoi, aa, &length, &length);
	
	/* Create the array ctype. */
	cast_type ctype = cast_new_type(CAST_TYPE_ARRAY);
	ctype->cast_type_u_u.array_type.length = cast_new_expr_lit_int(length,
								       0);
	ctype->cast_type_u_u.array_type.element_type = to_ctype;
	
	/* Create the array mapping. */
	pres_c_mapping map = pres_c_new_mapping(PRES_C_MAPPING_FIXED_ARRAY);
	pres_c_mapping_fixed_array *array_map
		= &(map->pres_c_mapping_u_u.fixed_array);
	
	/*
	 * We never need to allocate storage when the corresponding C type is
	 * an array, but we *do* need to allocate storage when the C type is a
	 * pointer (pointer-to-array-element).  The allocation flags in
	 * `array_map' only apply when the C type is a pointer type.  See the
	 * function `mu_state::mu_mapping_fixed_array' in the back end.
	 *
	 * You might be confused because we just set our presented C type to be
	 * an array type.  But some later code (e.g., `pg_corba::p_param_type'
	 * or `mu_state::mu_server_func') may change the type to be a pointer
	 * type.
	 */
	if (gen_client)
		array_map->alloc.flags = (PRES_C_ALLOC_ALWAYS
					  | PRES_C_DEALLOC_NEVER);
	else if (gen_server)
		array_map->alloc.flags = (PRES_C_ALLOC_ALWAYS
					  | PRES_C_DEALLOC_ALWAYS);
	else
		panic("In `pg_state::p_fixed_array_type', "
		      "generating neither client nor server.");
	
	array_map->alloc.allocator = p_get_allocator();
	
	array_map->length = length;
	array_map->element_mapping = to_map;
	
	/* Finally, return our resultant `out_ctype' and `out_map'. */
	*out_ctype = ctype;
	*out_map = map;
}

/* End of file. */

