/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/c/pfe.hh>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

/*
 * If you override this method, you should also override `p_interface_type',
 * which handles normal interface declarations.
 */
void pg_state::p_forward_type(cast_type *out_ctype, pres_c_mapping *out_map)
{
	/*
	 * Here we are handling *basic* interface types, not *typedef'ed*
	 * interface types.  This method is called by `p_type' when we have a
	 * direct reference to an AOI forward interface.  References to
	 * *specific* interface types always occur through AOI_INDIRECT nodes,
	 * and so we handle those cases in `p_indirect_type'.
	 */
	if (gen_client)
		*out_ctype =
			cast_new_type_name(
				calc_client_basic_object_type_name(
					a(cur_aoi_idx).name /* XXX ? */
					));
	else if (gen_server)
		*out_ctype =
			cast_new_type_name(
				calc_server_basic_object_type_name(
					a(cur_aoi_idx).name /* XXX ? */
					));
	else
		panic("In `pg_state::p_forward_type', "
		      "generating neither client nor server.");
	
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_REFERENCE);
	(*out_map)->pres_c_mapping_u_u.ref.kind = PRES_C_REFERENCE_COPY;
	(*out_map)->pres_c_mapping_u_u.ref.ref_count = 1;
}

/* End of file. */

