/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libpres_c.h>

#include "private.hh"

pres_c_inline pg_state::p_inline_add_atom(cast_type inl_ctype,
					  char *atom_name,
					  cast_type atom_ctype,
					  pres_c_mapping atom_mapping)
{
	cast_field *field;
	int field_num;
	
	/* Add a new field to the struct slot/function parameter list. */
	switch (inl_ctype->kind) {
	default:
		panic("In `pg_state::p_inline_add_atom', "
		      "unknown `inl_ctype' kind %d",
		      inl_ctype->kind);
		break;
		
	case CAST_TYPE_STRUCT: {
		cast_struct_type *st = &(inl_ctype->cast_type_u_u.struct_type);
		
		field_num = st->slots.slots_len++;
		
		st->slots.slots_val = (cast_struct_slot *)
				      mustrealloc(st->slots.slots_val,
						  (st->slots.slots_len
						   * sizeof(cast_field)));
		field = &(st->slots.slots_val[field_num]);
		
		break;
	}
	}
	
	/* Fill in the field. */
	field->name = atom_name;
	field->type = atom_ctype;

	/* Create an `inline_atom' referring to that slot. */
	return pres_c_new_inline_atom(field_num, atom_mapping);
}

/* End of file. */

