/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

void pg_state::p_optional_type(aoi_optional *ao,
			       cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_type to_ctype, ctype;
	pres_c_mapping to_map, map;
	
	pres_c_mapping_optional_pointer *the_pointer;
	
	/* Create the ctype and mapping for the optional target. */
	p_type(ao->type, &to_ctype, &to_map);
	
	/* Create the pointer ctype. */
	ctype = cast_new_pointer_type(to_ctype);
	
	/* Create the mapping.  An optional maps as an optional pointer, which
	   corresponds to a MINT array (a counted array with zero or one
	   elements).  See `aoi_to_mint()' for more information. */
	map = pres_c_new_mapping(PRES_C_MAPPING_OPTIONAL_POINTER);
	the_pointer = &(map->pres_c_mapping_u_u.optional_pointer);
	the_pointer->alloc.flags = (PRES_C_ALLOC_ALWAYS |
				    PRES_C_DEALLOC_NEVER);
	the_pointer->alloc.allocator = p_get_allocator();
	the_pointer->target = to_map;
	
	/* Return the ctype and the map. */
	*out_ctype = ctype;
	*out_map = map;
}

