/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libpres_c.h>
#include <mom/libaoi.h>

#include "private.hh"

void pg_state::p_scalar_type(aoi_scalar *as,
			      cast_type *out_ctype, pres_c_mapping *out_map)
{
	p_scalar(as->bits, as->flags != AOI_SCALAR_FLAG_UNSIGNED,
		 out_ctype, out_map);
}

void pg_state::p_scalar(int bits, int is_signed, 
			cast_type *out_ctype, pres_c_mapping *out_map) 
{
	cast_primitive_kind kind;
	cast_primitive_modifier mod;

	kind = CAST_PRIM_INT;
	// mod = (is_signed ? CAST_MOD_SIGNED : CAST_MOD_UNSIGNED);
	/* It is problematic to make an integer `signed' just because it's not
	   unsigned.  (`signed x' is not always equivalent to `x'.)  The
	   reverse is also true, but is not so problematic in practice.  What
	   we really need are flag bits in the AOI integer like those we have
	   for AOI characters. */
	mod = (is_signed ? 0 : CAST_MOD_UNSIGNED);
	
	/* XXX machine-dependent */
	switch (bits) {
	case 1: /* Added this JIC - booleans should be 1, not 8 */
	case 8:
		kind = CAST_PRIM_CHAR;
		break;
	case 16:
		mod |= CAST_MOD_SHORT;
		break;
	case 32:
		// mod |= CAST_MOD_LONG;
		/* Similarly, `long int' is not the same as `int'. */
		break;
	case 64:
		mod |= CAST_MOD_LONG_LONG;
		break;
	default:
		panic("unknown number of int bits");
	}
	
	*out_ctype = cast_new_prim_type(kind, mod);
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}
