/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "private.hh"

void pg_state::p_union_type(aoi_union *au,
			    cast_type *out_ctype, pres_c_mapping *out_map)
{
	/*
	 * Create a CAST_TYPE_STRUCT.
	 * The C presentation for an AOI union is not just a C union, but
	 * rather, a C struct containing a discriminator field and a C union.
	 */
	cast_type ctype = cast_new_struct_type(0);
	
	ctype->cast_type_u_u.struct_type.name = calc_type_name(a(cur_aoi_idx).
							       name);
	
	/* This PRES_C_MAPPING_STRUCT ``bumps'' us into inline mode. */
	pres_c_mapping map = pres_c_new_mapping(PRES_C_MAPPING_STRUCT);
	
	/* For an AOI union type, we will use a PRES_C inline struct_union. */
	map->pres_c_mapping_u_u.struct_i = p_inline_struct_union(au, ctype);
	
	*out_ctype = ctype;
	*out_map = map;
}

/* End of file. */

