/*
 * Copyright (c) 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>
#include <mom/libaoi.h>

#include <mom/c/pfe.hh>

/*
 * There is no `pg_state' implementation of `p_variable_array_type' because the
 * mapping of variable-length arrays varies so widely between presentations, so
 * there is no way to provide a useful ``default'' version.
 */

/*****************************************************************************/

/*
 * We can, however, provide useful defaults for the `p_variable_array_type'
 * auxiliary methods.
 */

void pg_state::p_variable_array_length_type(aoi_array */*array*/,
					    cast_type *out_ctype,
					    pres_c_mapping *out_map)
{
	/*
	 * Determine the CAST type and PRES_C mapping for the length of (i.e.,
	 * number of elements in) a variable-length array (e.g., a CORBA
	 * sequence).
	 */
	p_scalar(32, 0, out_ctype, out_map);
	
	/*
	 * Identify this datum as a ``length'' for the benefit of back end
	 * code generation.
	 */
	pres_c_interpose_argument(out_map, "length");
}

void pg_state::p_variable_array_maximum_type(aoi_array */*array*/,
					     cast_type *out_ctype,
					     pres_c_mapping *out_map)
{
	/*
	 * Determine the CAST type and PRES_C mapping for the allocated length
	 * (i.e., `malloc'ed number of slots) of a variable-length array (e.g.,
	 * a CORBA sequence).
	 */
	p_scalar(32, 0, out_ctype, out_map);
	
	/*
	 * The `out_map' returned by `p_scalar' is correct if we were going to
	 * marshal/unmarshal the allocated length, but that's not what we want.
	 * Rather, we ``ignore'' the value when m/u'ing but identify it as the
	 * ``maximum'' so that the back end can do something special when it
	 * generates code.  (See `mu_state::mu_inline_counted_array'.)
	 */
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_IGNORE);
	pres_c_interpose_argument(out_map, "maximum");
}

/* End of file. */

