/*
 * Copyright (c) 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <string.h>

#include <mom/compiler.h>
#include <mom/c/pfe.hh>

pg_state::pg_state()
{
	/*
	 * Initialize our AOI, MINT, and PRES_C data members.
	 */
	in_aoi = 0;
	out_pres = 0;
	top_union = mint_ref_null;
	aoi_to_mint_association = 0;
	
	/*
	 * Initailize the switches that control the presentation.
	 */
	gen_client = 0;
	gen_server = 0;
	
	client_stubs_for_inherited_operations = 1;
	server_funcs_for_inherited_operations = 1;
	
	/*********************************************************************/
	
	/*
	 * Initialize the strings that are used to construct names.  Most
	 * presentation generators will override at least some of these values.
	 */
#define NAME_FORMAT(type)      names.formats[name_strings::##type##_fmt]
#define NAME_LITERAL_STR(type) names.literals[name_strings::##type##_lit].str
#define NAME_LITERAL_LEN(type) names.literals[name_strings::##type##_lit].len
	
	/* The `null' format should never ever be used. */
	NAME_FORMAT(null) =			"";
	
	NAME_FORMAT(client_stub) =		"%S";
	NAME_FORMAT(server_skel) =		"%I%_server";
	NAME_FORMAT(server_func) =		"%I%_server%_%s";
	NAME_FORMAT(marshal_stub) =		"flick%_marshal%_stub%_%S";
	NAME_FORMAT(unmarshal_stub) =		"flick%_unmarshal%_stub%_%S";
	
	NAME_FORMAT(const) =				"%S";
	NAME_FORMAT(type) =				"%S";
	
	NAME_FORMAT(enum_tag) =				"%S";
	NAME_FORMAT(enum_member) =			"%S";
	
	NAME_FORMAT(struct_slot) =			"%s";
	NAME_FORMAT(struct_union_tag) =			"";
	/*
	 * XXX --- Do we need access to the structure type name?
	 * XXX --- Do we need multiple format strings for different classes of
	 *         structure slots (e.g., discriminators)?
	 */
	
	// NAME_FORMAT(struct_union_discrim_slot) = ;
	
	NAME_FORMAT(client_basic_object_type) =		"flick_ref_t";
	NAME_FORMAT(server_basic_object_type) =		"flick_ref_t";
	
	NAME_FORMAT(client_interface_object_type) =	"%S";
	NAME_FORMAT(server_interface_object_type) =	"%S";
	
	NAME_FORMAT(client_stub_object_type) =		"%I";
	NAME_FORMAT(server_func_object_type) =		"%I";
	
	NAME_FORMAT(client_stub_environment_type) =	"flick_env_t";
	NAME_FORMAT(server_func_environment_type) =	"flick_env_t";
	
	NAME_FORMAT(client_stub_client_sid_type) =	"flick_sid_t";
	NAME_FORMAT(server_func_client_sid_type) =	"flick_sid_t";
	
	NAME_FORMAT(client_stub_server_sid_type) =	"flick_sid_t";
	NAME_FORMAT(server_func_server_sid_type) =	"flick_sid_t";
	
	NAME_FORMAT(stub_param) =			"%s";

	/* volkmar: only needed for L4 - initialized for sanity */
	NAME_FORMAT(rcv_fpage_descriptor_param) =       "";
	NAME_FORMAT(rcv_fpage_descriptor_type) =        "";

	/*
	 * XXX --- Change the names of the special stub parameters at your own
	 * peril!  For example, the runtime header files have certain parameter
	 * names hardwired.
	 *
	 * XXX --- It is important for the name of each special parameter to
	 * begin with an underscore, so that the back end won't munge the names
	 * when creating the corresponding local variable within a server
	 * dispatch function (and thus induce the runtime compatibility problem
	 * described above).
	 */
	NAME_FORMAT(client_stub_object_param) =			"_obj";
	NAME_FORMAT(server_func_object_param) =			"_obj";
	
	NAME_FORMAT(client_stub_environment_param) =		"_env";
	NAME_FORMAT(server_func_environment_param) =		"_env";
	
	NAME_FORMAT(client_stub_client_sid_param) =		"_csid";
	NAME_FORMAT(server_func_client_sid_param) =		"_csid";
	
	NAME_FORMAT(client_stub_required_server_sid_param) =	"_ssid";
	NAME_FORMAT(server_func_required_server_sid_param) =	"_ssid";
	
	NAME_FORMAT(client_stub_actual_server_sid_param) =	"_out_ssid";
	NAME_FORMAT(server_func_actual_server_sid_param) =	"_out_ssid";
	/*
	 * XXX --- Do we need access to the name of the operation/stub?
	 */
	
	NAME_FORMAT(operation_request_code) =		"%S";
	NAME_FORMAT(operation_reply_code) =		"%S";
	
	NAME_FORMAT(exception_type) =			"%S";
	NAME_FORMAT(exception_code) =			"%S";
	
	NAME_FORMAT(allocator_function) =		"malloc";
	NAME_FORMAT(deallocator_function) =		"free";
	
	NAME_FORMAT(presentation_include_file) =	"flick%/pres%/%g.h";
	NAME_FORMAT(interface_include_file) =		"";
	NAME_FORMAT(interface_default_include_file) =	"";
	
	/*********************************************************************/
	
	/* The `null' literal should never ever be used. */
	NAME_LITERAL_STR(null) =			"";
	NAME_LITERAL_LEN(null) =			0;
	
	NAME_LITERAL_STR(separator) =			"_";
	NAME_LITERAL_LEN(separator) =			sizeof("_") - 1;
	
	NAME_LITERAL_STR(presentation_style) =		"generic";
	NAME_LITERAL_LEN(presentation_style) =		sizeof("generic") - 1;
	
	NAME_LITERAL_STR(filename_component_separator) = "/";
	NAME_LITERAL_LEN(filename_component_separator) = sizeof("/") - 1;
	
	/*********************************************************************/
	
	/*
	 * Initialize stateful data members.
	 */
	parent_interface_ref = aoi_ref_null;
	derived_interface_ref = aoi_ref_null;
	
	name = 0;
	cur_aoi_idx = 0;
	
	calc_name_data.count = 0;
	calc_name_data.size = 16;
	calc_name_data.components =
		(calc_name_component *)
		mustmalloc(sizeof(calc_name_component) * calc_name_data.size);
}

/* End of file. */

