/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */
#include <assert.h>
#include <mom/c/pg_corba.hh>
#include "dependency.hh"
#include "../macros.h"

void pg_corba::gen()
{
	build_init_cast();
	
	/* The first question is which interface defs we want presentations for.
	   Current answer: all named interface defs.
	   Later, maybe there'll be a way to get better control.
	   (For example, to get a presentation of an unnamed idef.)

	   this was done in two passes, leaving the interface defs for the second pass.
	   I changed it because of Module constructs in Corba
	   */
	
	namegraph = getScopeDep();
	for (cur_aoi_idx = 0; cur_aoi_idx < (aoi_ref)in_aoi->aoi_len; cur_aoi_idx++){
		/* Convert it to a C definition.  */
		assert(a(cur_aoi_idx).binding);
		if (a(cur_aoi_idx).scope == 0) {
			int defineNext = cur_aoi_idx;
			do {
				defineNext = namegraph->process(cur_aoi_idx);
				name = getscopedname(defineNext);
				
				int temp = cur_aoi_idx;
				cur_aoi_idx = defineNext;
				p_def(a(defineNext).binding);
				cur_aoi_idx = temp;
			} while (defineNext != cur_aoi_idx);
		}
	}
	delete namegraph;
}

/* End of file. */

