/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <mom/c/libpres_c.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/compiler.h>

#include <mom/c/pg_corba.hh>

void pg_corba::p_scalar(int bits, int is_signed, 
			cast_type *out_ctype, pres_c_mapping *out_map) 
{
	char *name;
	cast_primitive_kind kind;
	cast_primitive_modifier mod;

	switch (bits) {
	case 1:
	case 8:
		name = (bits == 1) ? "CORBA_boolean" : "CORBA_octet";
		kind = CAST_PRIM_CHAR;
		mod = CAST_MOD_UNSIGNED;
		break;
	case 16:
		name = is_signed ? "CORBA_short" : "CORBA_unsigned_short";
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_SHORT | (is_signed ? CAST_MOD_SIGNED : CAST_MOD_UNSIGNED);
		break;
	case 32:
		name = is_signed ? "CORBA_long" : "CORBA_unsigned_long";
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG | (is_signed ? CAST_MOD_SIGNED : CAST_MOD_UNSIGNED);
		break;
	case 64:
		name = is_signed ?  "CORBA_long_long" : "CORBA_unsigned_long_long";
		kind = CAST_PRIM_INT;
		mod = CAST_MOD_LONG_LONG | (is_signed ? CAST_MOD_SIGNED : CAST_MOD_UNSIGNED);
		break;
	default:
		panic("unknown number of int bits - %d", bits);
	}
	
	*out_ctype = cast_new_prim_alias(kind, mod, name);
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}

void pg_corba::p_float_type(aoi_float *ai,
			    cast_type *out_ctype, pres_c_mapping *out_map)
{
	assert (ai->bits == 32 || ai->bits == 64);
	*out_ctype = cast_new_prim_alias((ai->bits==32) ? CAST_PRIM_FLOAT : CAST_PRIM_DOUBLE, 0,
					(ai->bits==32) ? "CORBA_float" : "CORBA_double");
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}

void pg_corba::p_char_type(aoi_char *ac,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	assert(ac->bits == 8); /* XXX */
	assert(ac->flags == AOI_CHAR_FLAG_NONE);
		
	*out_ctype = cast_new_prim_alias(CAST_PRIM_CHAR, CAST_MOD_SIGNED, "CORBA_char");
	*out_map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}

cast_expr pg_corba::p_const_translate(aoi_const ac) 
{
	switch(ac->kind) {
	case AOI_CONST_INT:
		return cast_new_expr_lit_int(ac->aoi_const_u_u.const_int ,0);
	case AOI_CONST_CHAR:
		return cast_new_expr_lit_char(ac->aoi_const_u_u.const_char ,0);
	case AOI_CONST_FLOAT:
		return cast_new_expr_lit_float(ac->aoi_const_u_u.const_float);
	default:
		return pg_state::p_const_translate(ac);
	}
}
