/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include <mom/c/pg_corba.hh>

/*
 * XXX --- Note that this code is largely ineffectual because our current CORBA
 * front end always makes EMPTY enumerations!  It makes an `aoi_def' for each
 * member, and those are handled by `p_const_def'.  See `fe/newcorba/parser.yy'
 * for the gory details of why things are done this way.
 *
 * The upshot, however, is that we can't control the names of our enumeration
 * members through `calc_enum_member_name'.
 */
void pg_corba::p_enum_type(aoi_enum *ae,
			   cast_type *out_ctype, pres_c_mapping *out_map)
{
	int curval;
	
	char *name;
	int cdef;
	
	/*****/
	
	curval = 0;
	for (unsigned int i = 0; i < ae->defs.defs_len; i++) {
		name = calc_enum_member_name(ae->defs.defs_val[i].name);
		cdef = cast_add_def(&out_pres->cast);
		
		c(cdef).name = name;
		c(cdef).sc = CAST_SC_NONE;
		c(cdef).u.kind = CAST_DEFINE;
		
		if (ae->defs.defs_val[i].type->kind != AOI_CONST)
			c(cdef).u.cast_def_u_u.define_as =
				cast_new_expr_lit_int(curval,
						      (CAST_MOD_SIGNED
						       | CAST_MOD_LONG));
		else {
			c(cdef).u.cast_def_u_u.define_as =
				p_const_translate(ae->defs.defs_val[i].type->
						  aoi_type_u_u.const_def);
			curval = ae->defs.defs_val[i].type->
				 aoi_type_u_u.const_def->aoi_const_u_u.
				 const_int;
		}
		curval++;
	}
	
	*out_ctype = cast_new_prim_alias(CAST_PRIM_INT,
					 (CAST_MOD_UNSIGNED | CAST_MOD_LONG),
					 /*
					  * Do not call `calc_type_name' for
					  * this; that method is for typedef'ed
					  * names, not base type names.
					  */
					 "CORBA_enum");
	
	*out_map   = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
}

/* End of file. */

