/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/libmint.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include <mom/c/pg_corba.hh>

void pg_corba::p_except_type(aoi_exception *as, cast_type *out_ctype,
			     pres_c_mapping *out_map)
{	
	int cdef = cast_add_def(&out_pres->cast);
	c(cdef).name = calc_exception_code_name(a(cur_aoi_idx).name);
	c(cdef).sc = CAST_SC_NONE;
	c(cdef).u.kind = CAST_DEFINE;
	c(cdef).u.cast_def_u_u.define_as =
		cast_new_expr_lit_string(get_repository_id(cur_aoi_idx));
	c(cdef).included = a(cur_aoi_idx).included;
	pg_state::p_except_type(as, out_ctype, out_map);
}

cast_type pg_corba::p_get_env_struct_type() 
{
	static cast_type env = 0;
	if (env)
		return env;
	env = cast_new_struct_type(3);
	cast_struct_slot major, except, id;
	major.name = "_major";
	major.type = cast_new_type_name("CORBA_exception_type");
#if 0
	/* XXX - This is what we should do, but the pres_c doesn't handle it */
	except.name = "_value";
	except.type = cast_new_union_type(2);
	cast_union_add_case(except, "_system_except", cast_new_type_name(
		"flick_system_exception"));
	cast_union_add_case(except, "_user_except", cast_new_pointer_type(
		cast_new_type(CAST_TYPE_VOID)));
#else
	/* XXX - This is what we do now */
	except.name = "_value._user_except";
	except.type = cast_new_pointer_type(cast_new_type(CAST_TYPE_VOID));
#endif
	
	id.name = "_id";
	id.type = cast_new_pointer_type(cast_new_prim_type(CAST_PRIM_CHAR, 0));
	
	if (gen_client)
		env->cast_type_u_u.struct_type.name
			= calc_client_stub_environment_type_name("");
	else if (gen_server)
		env->cast_type_u_u.struct_type.name
			= calc_server_func_environment_type_name("");
	else
		panic("In `pg_corba::p_get_env_struct_type', "
		      "generating neither client nor server.");
	
	env->cast_type_u_u.struct_type.slots.slots_val[0] = major;
	env->cast_type_u_u.struct_type.slots.slots_val[1] = except;
	env->cast_type_u_u.struct_type.slots.slots_val[2] = id;
	
	return env;
}

char *pg_corba::p_get_exception_discrim_name() 
{
	return flick_asprintf("%s->%s",
			      (gen_client ?
			       calc_client_stub_environment_param_name("") :
			       calc_server_func_environment_param_name("")),
			      (p_get_env_struct_type()->cast_type_u_u.
			       struct_type.slots.
			       slots_val[p_get_exception_discrim()].name));
}

int pg_corba::p_get_exception_discrim()
{
	return 0;
}

int pg_corba::p_get_exception_void()
{
	return 1;
}

pres_c_inline_atom pg_corba::p_get_user_discrim() 
{
#define ASSIGN_DISCRIM_STATICALLY
#ifdef ASSIGN_DISCRIM_STATICALLY
#undef ASSIGN_DISCRIM_STATICALLY
	/* The discriminator won't be unmarshalled.  It will be assigned the
	   exact literal value upon entering the chosen branch of the union. */
	pres_c_mapping ta
		= pres_c_new_mapping(PRES_C_MAPPING_IGNORE);
#else
	pres_c_mapping ta
		= pres_c_new_mapping(PRES_C_MAPPING_TERMINATED_ARRAY);
	
	ta->pres_c_mapping_u_u.terminated_array.terminator
		= 0;
	ta->pres_c_mapping_u_u.terminated_array.max
		= 0;
	ta->pres_c_mapping_u_u.terminated_array.element_mapping
		= pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
	/*
	 * When we encode, we don't free the string since we assume it to
	 * be a literal string (e.g. ex_CORBA_NO_MEM).  When we decode,
	 * we have to allocate space in order to process it, but we should
	 * quickly deallocate it after locating a static (literal) copy of
	 * that id in a table.  XXX - lookup not done yet.
	 */
	ta->pres_c_mapping_u_u.terminated_array.alloc.flags
		= (PRES_C_ALLOC_ALWAYS | PRES_C_DEALLOC_NEVER);
	ta->pres_c_mapping_u_u.terminated_array.alloc.allocator
		= p_get_allocator();
#endif
	
	// Note the assumption that the identifier is in position 2!!!
	return pres_c_new_inline_atom(2, ta)->pres_c_inline_u_u.atom;
}

pres_c_inline_void_union_case *pg_corba::p_build_user_exceptions(int icase) 
{
	assert(m(icase).kind == MINT_UNION);
	
	mint_union_def *mu = &(m(icase).mint_def_u.union_def);
	int size = mu->cases.cases_len, i;
	aoi_ref j;
	
	pres_c_inline_void_union_case *vuc =
		(pres_c_inline_void_union_case *)
		mustcalloc(sizeof(pres_c_inline_void_union_case) * size);
	
	for (i = 0; i < size; i++) {
		mint_ref cur = mu->cases.cases_val[i].var;
		
		vuc[i].mapping
			= pres_c_new_mapping(PRES_C_MAPPING_POINTER);
		vuc[i].mapping->pres_c_mapping_u_u.pointer.alloc.flags
			= (PRES_C_ALLOC_ALWAYS | PRES_C_DEALLOC_ALWAYS);
		vuc[i].mapping->pres_c_mapping_u_u.pointer.alloc.allocator
			= p_get_allocator();
		vuc[i].mapping->pres_c_mapping_u_u.pointer.target
			= pres_c_new_mapping(PRES_C_MAPPING_STUB);
		
		int stub_idx = pres_c_find_mu_stub(out_pres, cur, 0,
						   (vuc[i].mapping->
						    pres_c_mapping_u_u.pointer.
						    target),
						   PRES_C_MARSHAL_STUB);
		
		vuc[i].mapping->pres_c_mapping_u_u.pointer.target->
			pres_c_mapping_u_u.mapping_stub.mapping_stub_index
			= stub_idx;
		
		/*
		 * Now build the type of the exception (just a pointer to a
		 * name.
		 */
		for (j = 0; j < (signed int)in_aoi->aoi_len; j++) {
			if (aoi_to_mint_association[j] == cur)
				break;
		}
		assert(j < (signed int)in_aoi->aoi_len);
		vuc[i].type = cast_new_type(CAST_TYPE_POINTER);
		vuc[i].type->cast_type_u_u.pointer_type.target
			= p_make_ctypename(j);
		
		/* Convert the MINT discriminator value for this branch. */
		vuc[i].case_value =
			p_mint_exception_id_const_to_cast(
				mu->cases.cases_val[i].val);
	}
	
	return vuc;
}

int pg_corba::p_count_user_exceptions(int icase)
{
	mint_union_def *mu = &(m(icase).mint_def_u.union_def);
	return mu->cases.cases_len;
}

void pg_corba::p_do_exceptional_case(pres_c_inline_virtual_union_case *vucase, mint_union_case *ucase, int icase) 
{
	mint_ref system_exception_ref
		= out_pres->mint.standard_refs.system_exception_ref;
	
	if (!ucase
	    || (ucase->var != system_exception_ref)) {
		/*
		 * We have the default case, so this is the void union for the
		 * user exceptions.
		 */
		pres_c_inline void_inl
			= pres_c_new_inline(PRES_C_INLINE_VOID_UNION);
		
		void_inl->pres_c_inline_u_u.void_union.discrim
			= p_get_user_discrim();
		void_inl->pres_c_inline_u_u.void_union.void_index
			= p_get_exception_void();
		void_inl->pres_c_inline_u_u.void_union.cases.cases_val
			= p_build_user_exceptions(icase);
		void_inl->pres_c_inline_u_u.void_union.cases.cases_len
			= p_count_user_exceptions(icase);
		void_inl->pres_c_inline_u_u.void_union.dfault
			= 0;
		
		vucase->map = pres_c_new_mapping(PRES_C_MAPPING_POINTER);
		
		vucase->map->pres_c_mapping_u_u.pointer.alloc.flags
			= 0;
		vucase->map->pres_c_mapping_u_u.pointer.alloc.allocator
			= p_get_allocator();
		vucase->map->pres_c_mapping_u_u.pointer.target
			= pres_c_new_mapping(PRES_C_MAPPING_STRUCT);
		vucase->map->pres_c_mapping_u_u.pointer.target->
			pres_c_mapping_u_u.struct_i
			= void_inl;
		
		vucase->ctype = cast_new_type(CAST_TYPE_POINTER);
		
		vucase->ctype->cast_type_u_u.pointer_type.target
			= p_get_env_struct_type();
		vucase->name
			= (gen_client ?
			   calc_client_stub_environment_param_name("") :
			   calc_server_func_environment_param_name(""));
		
	} else if (ucase && (ucase->var == system_exception_ref)) {
		vucase->map
			= pres_c_new_mapping(PRES_C_MAPPING_SYSTEM_EXCEPTION);
		vucase->ctype
			= cast_new_type(CAST_TYPE_VOID);
		vucase->name
			= (gen_client ?
			   calc_client_stub_environment_param_name("") :
			   calc_server_func_environment_param_name(""));
		
	} else
		panic("Don't know how to deal with a user exception that is "
		      "not in the default slot!");
}

void pg_corba::p_do_return_union(aoi_operation *ao,
				 pres_c_inline* reply_l4_inl,
				 mint_ref reply_ref,
				 cast_ref cfunc)
{
	mint_union_def *mu = &(m(reply_ref).mint_def_u.union_def);
	
	assert(mu->cases.cases_len == 2);
	
	mu->cases.cases_val[0].val
		= mint_new_symbolic_const(MINT_CONST_INT,
					  "CORBA_NO_EXCEPTION");
	mu->cases.cases_val[1].val
		= mint_new_symbolic_const(MINT_CONST_INT,
					  "CORBA_SYSTEM_EXCEPTION");
	
	pg_state::p_do_return_union(ao, reply_l4_inl, reply_ref, cfunc);
}

/* End of file. */

