/*
 * Copyright (c) 1995, 1996, 1997 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include <mom/c/pg_corba.hh>

void pg_corba::p_interface_def_typedef(aoi_interface *a)
{
	aoi_type_u at;
	
	at.kind                       = AOI_INTERFACE;
	at.aoi_type_u_u.interface_def = *a;
	
	/* Define the interface type as a data object with real marshal and
	   unmarshal functions. */
	p_typedef_def(&at);
}

void pg_corba::p_interface_type(aoi_interface * /*ai*/,
				cast_type *out_ctype, pres_c_mapping *out_map)
{
	/* Call the method that we use for forward interface declarations. */
	p_forward_type(out_ctype, out_map);
}

/* End of file. */

