/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */
#include "../macros.h"
#include <mom/c/pg_corba.hh>
#include "dependency.hh"

dep *pg_corba::getScopeDep() {
	/* this will return a dependency graph for the given local scope
	   if it has already been handled, don't bother!
	   it's kind of hairy.  consider the following struct:
			scoped name	scope #	definition order
			===========	==	==
	   struct a {	a		0	8
	    struct b {	a_b		1	1
	     ...
	    } foo;
	    struct c {	a_c		1	6
	     struct d {	a_c_d		2	3
	      struct e {a_c_d_e		3	2
	       ...
	      } foo0;
	      ...
	     } foo1;
	     struct e {	a_c_e		2	5
	      struct f {a_c_e_f		3	4
		       ...
	      } foo0;
	     } foo2;
	     ...
	    } foo3;
	    struct d {	a_d		1	7
	     ...
	    } foo4;
	   };
	   struct b {	b		0	9
	    ...
	   };
	   
	   Stare at that table long enough, or just try to decode the following:
	   If the next undefined item's scope in the aoi is the same as the current,
	    define this element.
	   If the next undefined item's scope is HIGHER than the current element,
	    remember this location and move on to the next one.
	   If the next undefined item's scope is LOWER than the current element,
	    go back to the last 'remembered' location and continue the comparison.
	    if there is no last undefined location, define the current one.
	   If there is no 'next undefined scope' define the closest previous one. 
	   */
	dep *res=new dep(in_aoi->aoi_len);
	unsigned int next_num=0;
	while(next_num < in_aoi->aoi_len)
		next_num = buildDep(res,next_num);
	return res;
}

int pg_corba::buildDep(dep *res, int start) {
	unsigned int next_pos;
	for(next_pos = start+1; next_pos < in_aoi->aoi_len; next_pos++ ) {
		if(a(next_pos).scope <= a(start).scope) {
			// we've found the end of our dependencies
			for(int pos = next_pos-1; pos > start; pos--) {
				if(a(pos).scope == a(start).scope+1) {
					res->add(start, pos);
					buildDep(res, pos);
				}
			}
			return next_pos;
		}
	}
	for(int pos = in_aoi->aoi_len-1; pos > start; pos--) {
		if(a(pos).scope == a(start).scope+1) {
			res->add(start, pos);
			buildDep(res, pos);
		}
	}
	return next_pos;
}








