/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "pg_sun.hh"

void pg_sun::p_integer_type(aoi_integer *ai,
			    cast_type *out_ctype, pres_c_mapping *out_map)
{
	cast_type ctype;
	pres_c_mapping map;
	int bits, is_signed;
	cast_primitive_kind kind;
	cast_primitive_modifier mod;
	
	aoi_get_int_size(ai, &bits, &is_signed);
	kind = CAST_PRIM_INT;
	// mod = (is_signed ? CAST_MOD_SIGNED : CAST_MOD_UNSIGNED);
	/* It is problematic to make an integer `signed' just because it's not
	   unsigned.  (`signed x' is not always equivalent to `x'.)  The
	   reverse is also true, but is not so problematic in practice.  What
	   we really need are flag bits in the AOI integer like those we have
	   for AOI characters. */
	mod = (is_signed ? 0 : CAST_MOD_UNSIGNED);
	
	/* XXX machine-dependent */
	switch (bits) {
	case 1:
		kind = CAST_PRIM_INT;
		mod = 0;
		break;
	case 8:
		kind = CAST_PRIM_CHAR;
		break;
	case 16:
		mod |= CAST_MOD_SHORT;
		break;
	case 32:
		// mod |= CAST_MOD_LONG;
		/* Similarly, `long int' is not the same as `int'. */
		break;
	case 64:
		mod |= CAST_MOD_LONG_LONG;
		break;
	default:
		panic("unknown number of int bits");
	}
	
	ctype = cast_new_prim_type(kind, mod);
	map = pres_c_new_mapping(PRES_C_MAPPING_DIRECT);
	
	*out_ctype = ctype;
	*out_map = map;
}

