/*
 * Copyright (c) 1995, 1996, 1997, 1998 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <assert.h>
#include <string.h>

#include <mom/compiler.h>
#include <mom/libaoi.h>
#include <mom/c/libcast.h>
#include <mom/c/libpres_c.h>

#include "pg_sun.hh"

/* XXX The allocation and deallocation flags need to be reexamined ---
   I just guessed as to what they should be.
   I also need to know more about `pres_c_interpose_pointer()' and
   what it does with its fourth argument.
   */

/* This version of `p_variable_array_type()' overrides the one in `c/pfe/lib'.
   This version is specific to Sun RPC.
 */

void pg_sun::p_variable_array_type(aoi_array *array,
				   cast_type *out_ctype,
				   pres_c_mapping *out_map)
{
	cast_type ctype, element_ctype;
	pres_c_mapping map, element_map;
	
	/* Create the ctype and mapping for the array's element type. */
	p_type(array->element_type, &element_ctype, &element_map);
	
	if (array->flgs & AOI_ARRAY_FLAG_NULL_TERMINATED_STRING) {
		/* We are mapping a null-terminated array --- most likely, a
		   string.  The Sun RPC mapping for a null-terminated array is
		   straightforward. */
		ctype = cast_new_pointer_type(element_ctype);
		
		/* Create the map. */
		map = pres_c_new_mapping(PRES_C_MAPPING_TERMINATED_ARRAY);
		/* The terminator is the literal value of the terminator,
		   not a reference to a literal value. */
		map->pres_c_mapping_u_u.terminated_array.terminator = 0;
		map->pres_c_mapping_u_u.terminated_array.max = 0;
		map->pres_c_mapping_u_u.terminated_array.element_mapping =
			element_map;
		map->pres_c_mapping_u_u.terminated_array.alloc.allocator =
			p_get_allocator();
		/* The allocation flags are identical for client and server.
		   A Sun RPC client never deallocates a string in a request,
		   but always always allocates space for a string in a reply,
		   Conversely, a Sun RPC server skeleton always allocates space
		   for a request string, but never deallocates a string in a
		   reply.  (Yes: A Sun server skeleton *never* deallocates
		   pointers in a reply!  That's how `rpcgen'-generated code
		   works.) */
		map->pres_c_mapping_u_u.terminated_array.alloc.flags =
			(PRES_C_ALLOC_ALWAYS | PRES_C_DEALLOC_NEVER);
	} else {
		/*
		 * We are mapping a counted array.
		 * This maps onto a structure with `_len' and `_val' fields.
		 */
		cast_struct_type *array_struct;
		cast_type len_ctype;
		pres_c_mapping len_map;
		int array_name_len;
		char *len_name, *val_name;
		
		pres_c_inline the_inline;
		pres_c_inline_counted_array *inline_array;
		
		/* Create the structure. */
		ctype = cast_new_struct_type(2);
		array_struct = &(ctype->cast_type_u_u.struct_type);
		/*
		 * The `array_struct->name' field is the name of the structure
		 * type, and we don't want to name the type.  We can't set the
		 * name to NULL, however, because `cast_check_struct_type()'
		 * insists that the name be non-NULL.  So we use an empty
		 * string.
		 */
		array_struct->name = "";
		
		/*
		 * Determine the names of the structure fields.  Note that
		 * sizeof() counts the NUL at the end of a string.
		 */
		array_name_len = strlen(name);
		len_name = (char *) mustmalloc(array_name_len +
					       sizeof("_len"));
		val_name = (char *) mustmalloc(array_name_len +
					       sizeof("_val"));
		strcpy(len_name, name);
		strcat(len_name, "_len");
		strcpy(val_name, name);
		strcat(val_name, "_val");
		
		/* Now fill in the structure field definitions. */
		p_variable_array_length_type(array, &len_ctype, &len_map);
		/*
		 * No need to call `p_variable_array_maximum_type'; the ONC RPC
		 * presentation of variable-length arrays does not expose the
		 * allocated array length.
		 */
		
		array_struct->slots.slots_val[0].name = len_name;
		array_struct->slots.slots_val[0].type = len_ctype;
		array_struct->slots.slots_val[1].name = val_name;
		array_struct->slots.slots_val[1].type =
			cast_new_pointer_type(element_ctype);
		
		/* Create the counted-array mapping.  */
		the_inline = pres_c_new_inline(PRES_C_INLINE_COUNTED_ARRAY);
		inline_array = &(the_inline->pres_c_inline_u_u.counted_array);
		inline_array->len = pres_c_new_inline_atom(0, len_map);
		inline_array->max = 0; /* Sun RPC doesn't encode the max. */
		inline_array->ptr.index = 1;
		
		/* Interpose a pointer.
		   As stated in `pres_c.x', there must be at least one level of
		   PRES_C_MAPPING_POINTER here. */
		pres_c_interpose_pointer(&element_ctype, &element_map,
					 (PRES_C_ALLOC_ALWAYS |
					  PRES_C_DEALLOC_NEVER),
					 "sun");
		
		inline_array->ptr.mapping = element_map;
		/* There are zero additional levels of pointer indirection. */
		inline_array->ptr_levels = 0;
		
		/* Finally, create the map. */
		map = pres_c_new_mapping(PRES_C_MAPPING_STRUCT);
		map->pres_c_mapping_u_u.struct_i = the_inline;
	}
	
	*out_ctype = ctype;
	*out_map = map;
}

/* End of file. */

