/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include "Errors.hh"
#include <stdio.h>
#include <stdarg.h>

int lineno = 0;
char linebuf[BUFSIZE] = ""; /* buffer for entire lines of IDL code */
char errorlinebuf[BUFSIZE] = "";
int tokenpos = 0, nextPos = 0, errorPos;
int lnum;
int errorcount = 0;
int warningcount = 0;
int fail;
int errorflag;
extern char *infilename;

void
ShowErrorPos()
{
  if (errorlinebuf[strlen(errorlinebuf) - 1] == '\n') 
    fprintf(stderr,"%s%*s\n", errorlinebuf, 1+errorPos, "^");
  else
    fprintf(stderr,"%s\n%*s\n", errorlinebuf, 1+errorPos, "^");
}

void 
TypeError(char *msg, char *txt) 
{
  strcpy(errorlinebuf,linebuf);
  errorPos = tokenpos;
  if (!txt)
    fprintf(stderr,"%s:%d:%d:error:%s\n", infilename, lineno, 1+errorPos, msg);
  else
    fprintf(stderr,"%s:%d:%d:error:%s %s\n", infilename, lineno, 1+errorPos, 
	    msg, txt);
  ShowErrorPos();
  ++errorcount;
  fail = 1;
}


void
ParseError(char *msg, ...) {
  va_list vl;

  fail = 1;
  if (errorflag) {
    ++errorcount;
    fprintf(stderr,"%s:%d:%d:error:", infilename, lineno, 1+errorPos);

    va_start(vl, msg);
    vfprintf(stderr, msg, vl);
    va_end(vl);

    fprintf(stderr,"\n");
    ShowErrorPos();
    errorflag = 0;
  }
}


void 
LexError(char *msg, char *txt) 
{
  strcpy(errorlinebuf,linebuf);
  errorPos = tokenpos;
  if (!txt)
    fprintf(stderr,"%s:%d:%d:error:%s\n", infilename, lineno, 1+errorPos, msg);
  else
    fprintf(stderr,"%s:%d:%d:error:%s %s\n", infilename, lineno, 1+errorPos, 
	    msg, txt);
  ShowErrorPos();
  ++errorcount;
  fail = 1;
}

void 
LexWarning(char *msg, char *txt) 
{
  ++warningcount;
  strcpy(errorlinebuf,linebuf);
  errorPos = tokenpos;
  if (!txt)
    fprintf(stderr,"%s:%d:%d:warning:%s\n", infilename, lineno, 1+errorPos, 
	    msg);
  else
    fprintf(stderr,"%s:%d:%d:warning:%s %s\n", infilename, lineno, 1+errorPos, 
	    msg, txt);
  ShowErrorPos();
}




