/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */


extern "C" {
#include <stdio.h>
#include <mom/compiler.h>
#include <mom/libaoi.h>	
}

extern FILE *yyin;
extern int yyparse();
extern int lineno, lnum;
extern int yydebug;
extern int fail;
extern int errorcount;
extern int warningcount;
extern aoi cur_aoi;
extern int yylex();
char *progname;
char *infilename;
char *real_filename;

int main(int argc, char *argv[])
{
	fe_flags res = front_end_args(argc, argv, "Note that this input to this front end must be 100% CORBA 2.0 compliant");
	FILE *output;
	fail = 0;
	
	if (!res.nocpp)
		yyin = call_c_preprocessor(res.input, res.cpp_flags);
	else if (res.input)
		yyin = fopen(res.input, "r");
	else
		yyin = stdin;
	
	infilename = res.input ? res.input : "<stdin>";
	real_filename = infilename;
	
	if (!yyin)
		panic("Can't open file '%s' for reading.", infilename);
	
	if (yyparse()) 
		panic("%s:%d:error:Confused by previous errors...",
		      infilename,
		      lineno);
	if (fail)
	        panic("%s:%i Error(s) and %i Warning(s)",
		      infilename,
		      errorcount,
		      warningcount);
	if (res.output)
		output = fopen(res.output, "wb");
	else
		output = stdout;
	
	aoi_writefh(&cur_aoi, output);
	return 0;
}
