/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <mom/compiler.h>
#include <mom/libaoi.h>

#include "rpc_parse.h"
#include "rpc_util.h"

extern int crash();
extern void translate();

char *progname;

definition *defs;
extern aoi outaoi;

static void read_defs(void)
{
	definition *def, **last_def;

	last_def = &defs;
	while ((def = get_definition()))
	{
		*last_def = def;
		last_def = &def->next;
	}
	*last_def = 0;
}

int main(int argc, char **argv)
{
	/* We're just a simple filter.  */
	XDR xdrs;
	FILE *out;
	fe_flags res = front_end_args(argc, argv, "Note that the XDR '%' option for inlining code is NOT supported");

	if (!res.nocpp)
		fin = call_c_preprocessor(res.input, res.cpp_flags);
	else if (res.input)
		fin = fopen(res.input, "r");
	else
		fin = stdin;
	
	if (!fin)
		panic("Can't open file '%s' for reading.", res.input ? res.input : "<stdin>");
	
	read_defs();
	translate();
	/* print_all(outaoi); */
	
	out = (res.output ? fopen(res.output, "wb") : stdout);
	
	xdrstdio_create(&xdrs, out, XDR_ENCODE);
	if (!xdr_aoi(&xdrs, &outaoi)) {
		panic("error writing AOI file\n");
	}
	xdr_destroy(&xdrs);
	return 0;
}

