#include <mom/aoi.h>
#include <rpc/rpc.h>


bool_t
xdr_aoi_ref(xdrs, objp)
	XDR *xdrs;
	aoi_ref *objp;
{
	if (!xdr_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_type(xdrs, objp)
	XDR *xdrs;
	aoi_type *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct aoi_type_u), xdr_aoi_type_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const(xdrs, objp)
	XDR *xdrs;
	aoi_const *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct aoi_const_u), xdr_aoi_const_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_int(xdrs, objp)
	XDR *xdrs;
	aoi_const_int *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_char(xdrs, objp)
	XDR *xdrs;
	aoi_const_char *objp;
{
	if (!xdr_char(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_float(xdrs, objp)
	XDR *xdrs;
	aoi_const_float *objp;
{
	if (!xdr_double(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_struct(xdrs, objp)
	XDR *xdrs;
	aoi_const_struct *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->aoi_const_struct_val, (u_int *)&objp->aoi_const_struct_len, ~0, sizeof(aoi_const), xdr_aoi_const)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_array(xdrs, objp)
	XDR *xdrs;
	aoi_const_array *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->aoi_const_array_val, (u_int *)&objp->aoi_const_array_len, ~0, sizeof(aoi_const), xdr_aoi_const)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_kind(xdrs, objp)
	XDR *xdrs;
	aoi_const_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_const_u(xdrs, objp)
	XDR *xdrs;
	aoi_const_u *objp;
{
	if (!xdr_aoi_const_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case AOI_CONST_INT:
		if (!xdr_aoi_const_int(xdrs, &objp->aoi_const_u_u.const_int)) {
			return (FALSE);
		}
		break;
	case AOI_CONST_CHAR:
		if (!xdr_aoi_const_char(xdrs, &objp->aoi_const_u_u.const_char)) {
			return (FALSE);
		}
		break;
	case AOI_CONST_FLOAT:
		if (!xdr_aoi_const_float(xdrs, &objp->aoi_const_u_u.const_float)) {
			return (FALSE);
		}
		break;
	case AOI_CONST_STRUCT:
		if (!xdr_aoi_const_struct(xdrs, &objp->aoi_const_u_u.const_struct)) {
			return (FALSE);
		}
		break;
	case AOI_CONST_ARRAY:
		if (!xdr_aoi_const_array(xdrs, &objp->aoi_const_u_u.const_array)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_field(xdrs, objp)
	XDR *xdrs;
	aoi_field *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_integer(xdrs, objp)
	XDR *xdrs;
	aoi_integer *objp;
{
	if (!xdr_int(xdrs, &objp->min)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->range)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_float(xdrs, objp)
	XDR *xdrs;
	aoi_float *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_char_flags(xdrs, objp)
	XDR *xdrs;
	aoi_char_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_char(xdrs, objp)
	XDR *xdrs;
	aoi_char *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	if (!xdr_aoi_char_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	return (TRUE);
}



bool_t
xdr_aoi_scalar_flags(xdrs, objp)
	XDR *xdrs;
	aoi_scalar_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_scalar(xdrs, objp)
	XDR *xdrs;
	aoi_scalar *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	if (!xdr_aoi_scalar_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_array_flags(xdrs, objp)
	XDR *xdrs;
	aoi_array_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_array(xdrs, objp)
	XDR *xdrs;
	aoi_array *objp;
{
	if (!xdr_aoi_type(xdrs, &objp->element_type)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->length_type)) {
		return (FALSE);
	}
	if (!xdr_aoi_array_flags(xdrs, &objp->flgs)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_struct_slot(xdrs, objp)
	XDR *xdrs;
	aoi_struct_slot *objp;
{
	if (!xdr_aoi_field(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_struct(xdrs, objp)
	XDR *xdrs;
	aoi_struct *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(aoi_struct_slot), xdr_aoi_struct_slot)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_union_case(xdrs, objp)
	XDR *xdrs;
	aoi_union_case *objp;
{
	if (!xdr_aoi_const(xdrs, &objp->val)) {
		return (FALSE);
	}
	if (!xdr_aoi_field(xdrs, &objp->var)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_union(xdrs, objp)
	XDR *xdrs;
	aoi_union *objp;
{
	if (!xdr_aoi_field(xdrs, &objp->discriminator)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->union_label, ~0)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(aoi_union_case), xdr_aoi_union_case)) {
		return (FALSE);
	}
	if (!xdr_pointer(xdrs, (char **)&objp->dfault, sizeof(aoi_field), xdr_aoi_field)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_direction(xdrs, objp)
	XDR *xdrs;
	aoi_direction *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_parameter(xdrs, objp)
	XDR *xdrs;
	aoi_parameter *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_aoi_direction(xdrs, &objp->direction)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_op_flags(xdrs, objp)
	XDR *xdrs;
	aoi_op_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_operation(xdrs, objp)
	XDR *xdrs;
	aoi_operation *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->request_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->reply_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_op_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->params.params_val, (u_int *)&objp->params.params_len, ~0, sizeof(aoi_parameter), xdr_aoi_parameter)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->return_type)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->exceps.exceps_val, (u_int *)&objp->exceps.exceps_len, ~0, sizeof(aoi_type), xdr_aoi_type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_attribute(xdrs, objp)
	XDR *xdrs;
	aoi_attribute *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->read_request_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->read_reply_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->write_request_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->write_reply_code)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->readonly)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_exception_slot(xdrs, objp)
	XDR *xdrs;
	aoi_exception_slot *objp;
{
	if (!xdr_aoi_field(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_exception(xdrs, objp)
	XDR *xdrs;
	aoi_exception *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(aoi_exception_slot), xdr_aoi_exception_slot)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_idl_id(xdrs, objp)
	XDR *xdrs;
	aoi_idl_id *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_interface(xdrs, objp)
	XDR *xdrs;
	aoi_interface *objp;
{
	if (!xdr_aoi_idl_id(xdrs, &objp->idl)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->code_type)) {
		return (FALSE);
	}
	if (!xdr_aoi_const(xdrs, &objp->code)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->parents.parents_val, (u_int *)&objp->parents.parents_len, ~0, sizeof(aoi_type), xdr_aoi_type)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->op_code_type)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->ops.ops_val, (u_int *)&objp->ops.ops_len, ~0, sizeof(aoi_operation), xdr_aoi_operation)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->attribs.attribs_val, (u_int *)&objp->attribs.attribs_len, ~0, sizeof(aoi_attribute), xdr_aoi_attribute)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->excepts.excepts_val, (u_int *)&objp->excepts.excepts_len, ~0, sizeof(aoi_type), xdr_aoi_type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_enum(xdrs, objp)
	XDR *xdrs;
	aoi_enum *objp;
{
	if (!xdr_string(xdrs, &objp->enum_label, ~0)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->defs.defs_val, (u_int *)&objp->defs.defs_len, ~0, sizeof(aoi_field), xdr_aoi_field)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_optional(xdrs, objp)
	XDR *xdrs;
	aoi_optional *objp;
{
	if (!xdr_aoi_type(xdrs, &objp->type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_kind(xdrs, objp)
	XDR *xdrs;
	aoi_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_type_u(xdrs, objp)
	XDR *xdrs;
	aoi_type_u *objp;
{
	if (!xdr_aoi_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case AOI_INDIRECT:
		if (!xdr_aoi_ref(xdrs, &objp->aoi_type_u_u.indirect_ref)) {
			return (FALSE);
		}
		break;
	case AOI_INTEGER:
		if (!xdr_aoi_integer(xdrs, &objp->aoi_type_u_u.integer_def)) {
			return (FALSE);
		}
		break;
	case AOI_FLOAT:
		if (!xdr_aoi_float(xdrs, &objp->aoi_type_u_u.float_def)) {
			return (FALSE);
		}
		break;
	case AOI_CHAR:
		if (!xdr_aoi_char(xdrs, &objp->aoi_type_u_u.char_def)) {
			return (FALSE);
		}
		break;
	case AOI_FPAGE:
	case AOI_INTRFC:
	case AOI_L4STRING:
	       break;
	case AOI_ARRAY:
		if (!xdr_aoi_array(xdrs, &objp->aoi_type_u_u.array_def)) {
			return (FALSE);
		}
		break;
	case AOI_STRUCT:
		if (!xdr_aoi_struct(xdrs, &objp->aoi_type_u_u.struct_def)) {
			return (FALSE);
		}
		break;
	case AOI_UNION:
		if (!xdr_aoi_union(xdrs, &objp->aoi_type_u_u.union_def)) {
			return (FALSE);
		}
		break;
	case AOI_INTERFACE:
		if (!xdr_aoi_interface(xdrs, &objp->aoi_type_u_u.interface_def)) {
			return (FALSE);
		}
		break;
	case AOI_EXCEPTION:
		if (!xdr_aoi_exception(xdrs, &objp->aoi_type_u_u.exception_def)) {
			return (FALSE);
		}
		break;
	case AOI_ENUM:
		if (!xdr_aoi_enum(xdrs, &objp->aoi_type_u_u.enum_def)) {
			return (FALSE);
		}
		break;
	case AOI_VOID:
		break;
	case AOI_CONST:
		if (!xdr_aoi_const(xdrs, &objp->aoi_type_u_u.const_def)) {
			return (FALSE);
		}
		break;
	case AOI_NAMESPACE:
		break;
	case AOI_OPTIONAL:
		if (!xdr_aoi_optional(xdrs, &objp->aoi_type_u_u.optional_def)) {
			return (FALSE);
		}
		break;
	case AOI_FWD_INTRFC:
		break;
	case AOI_ANY:
		break;
	case AOI_ERROR:
		break;
	case AOI_SCALAR:
		if (!xdr_aoi_scalar(xdrs, &objp->aoi_type_u_u.scalar_def)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_inclusion(xdrs, objp)
	XDR *xdrs;
	inclusion *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi_def(xdrs, objp)
	XDR *xdrs;
	aoi_def *objp;
{
	if (!xdr_string(xdrs, &objp->name, ~0)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->scope)) {
		return (FALSE);
	}
	if (!xdr_inclusion(xdrs, &objp->included)) {
		return (FALSE);
	}
	if (!xdr_aoi_type(xdrs, &objp->binding)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_aoi(xdrs, objp)
	XDR *xdrs;
	aoi *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->aoi_val, (u_int *)&objp->aoi_len, ~0, sizeof(aoi_def), xdr_aoi_def)) {
		return (FALSE);
	}
	return (TRUE);
}


