/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <mom/compiler.h>

#define BUFSIZE (256)

char *flick_asprintf(char *fmt, ...)
{
	va_list vl;
	
	char buf[BUFSIZE];
	char *str;
	int buf_len, str_len;
	
	va_start(vl, fmt);
#ifdef HAVE_VSNPRINTF
	buf_len = vsnprintf(buf, BUFSIZE, fmt, vl);
#else
	/* This may overrun `buf'... */
	vsprintf(buf, fmt, vl);
	buf_len = strlen(buf);
	assert(buf_len < BUFSIZE);
#endif
	va_end(vl);
	
	/* `vsnprintf' returns the number of characters in the formatted string
	   (minus the terminating NUL), *even if* `buf' wasn't large enough to
	   contain that string. */
	str = (char *) mustmalloc((buf_len + 1) * sizeof(char));
	if (buf_len >= BUFSIZE) {
		/* The initial buffer was not large enough to contain the
		   formatted string.  Call `vsnprintf' with a buffer of the
		   correct size. */
		va_start(vl, fmt);
#ifdef HAVE_VSNPRINTF
		str_len = vsnprintf(str, (buf_len + 1), fmt, vl);
#endif
		va_end(vl);
		assert(str_len == buf_len);
	} else {
		/* The initial buffer was large enough to contain the formatted
		   string.  Copy the string out of the buffer. */
		strcpy(str, buf);
		assert(strlen(str) == (unsigned int)buf_len);
	}
	
	return str;
}

