/*
 * Copyright (c) 1995, 1996 The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 *
 * This file is part of Flick, the Flexible IDL Compiler Kit.
 *
 * Flick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Flick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Flick; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place #330, Boston, MA 02111, USA.
 */

#include <mom/compiler.h>

fe_flags front_end_args(int argc, char **argv, char *info)
{
	flags_in in[6];
	flags_out out;
	fe_flags res;
	set_def_flags(in);
	in[4].sng = 'c';
	in[4].dbl = "cppflags";
	in[4].which = fk_STRING;
	in[4].dfault.string = 0;
	in[4].explain = "Pass the given flags to the C preprocessor";
	in[5].sng = 'n';
	in[5].dbl = "nocpp";
	in[5].which = fk_FLAG;
	in[5].dfault.flag = 0;
	in[5].explain = "Don't call the C preprocessor";
	out = parse_args(argc, argv, 6, in);
	std_handler(out, 6, in, "<optional input filename>", info);
	res.cpp_flags = out.flgs[4].string;
	res.nocpp = out.flgs[5].flag;
	if (out.other_count == 1)
		res.input = *out.other;
	else if (out.other_count) {
		print_args_usage(out.progname, 6, in, "<optional input filename>", info);
		exit(1);
	} else
		res.input = 0;
	progname = out.progname;
	res.output = out.flgs[2].string;
	if (res.input && !res.output)
		res.output = resuffix(res.input, ".aoi");
	return res;
}
