#include <mom/mint.h>
#include <rpc/rpc.h>


bool_t
xdr_mint_ref(xdrs, objp)
	XDR *xdrs;
	mint_ref *objp;
{ 
	if (!xdr_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const(xdrs, objp)
	XDR *xdrs;
	mint_const *objp;
{
	if (!xdr_pointer(xdrs, (char **)objp, sizeof(struct mint_const_u), xdr_mint_const_u)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_kind(xdrs, objp)
	XDR *xdrs;
	mint_const_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_category(xdrs, objp)
	XDR *xdrs;
	mint_const_category *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_int_u(xdrs, objp)
	XDR *xdrs;
	mint_const_int_u *objp;
{
	if (!xdr_mint_const_category(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case MINT_CONST_LITERAL:
		if (!xdr_long(xdrs, &objp->mint_const_int_u_u.value)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_SYMBOLIC:
		if (!xdr_string(xdrs, &objp->mint_const_int_u_u.name, ~0)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_char_u(xdrs, objp)
	XDR *xdrs;
	mint_const_char_u *objp;
{
	if (!xdr_mint_const_category(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case MINT_CONST_LITERAL:
		if (!xdr_char(xdrs, &objp->mint_const_char_u_u.value)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_SYMBOLIC:
		if (!xdr_string(xdrs, &objp->mint_const_char_u_u.name, ~0)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_float_u(xdrs, objp)
	XDR *xdrs;
	mint_const_float_u *objp;
{
	if (!xdr_mint_const_category(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case MINT_CONST_LITERAL:
		if (!xdr_double(xdrs, &objp->mint_const_float_u_u.value)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_SYMBOLIC:
		if (!xdr_string(xdrs, &objp->mint_const_float_u_u.name, ~0)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_struct(xdrs, objp)
	XDR *xdrs;
	mint_const_struct *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->mint_const_struct_val, (u_int *)&objp->mint_const_struct_len, ~0, sizeof(mint_const), xdr_mint_const)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_array(xdrs, objp)
	XDR *xdrs;
	mint_const_array *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->mint_const_array_val, (u_int *)&objp->mint_const_array_len, ~0, sizeof(mint_const), xdr_mint_const)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_const_u(xdrs, objp)
	XDR *xdrs;
	mint_const_u *objp;
{
	if (!xdr_mint_const_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case MINT_CONST_INT:
		if (!xdr_mint_const_int_u(xdrs, &objp->mint_const_u_u.const_int)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_CHAR:
		if (!xdr_mint_const_char_u(xdrs, &objp->mint_const_u_u.const_char)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_FLOAT:
		if (!xdr_mint_const_float_u(xdrs, &objp->mint_const_u_u.const_float)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_STRUCT:
		if (!xdr_mint_const_struct(xdrs, &objp->mint_const_u_u.const_struct)) {
			return (FALSE);
		}
		break;
	case MINT_CONST_ARRAY:
		if (!xdr_mint_const_array(xdrs, &objp->mint_const_u_u.const_array)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_def_kind(xdrs, objp)
	XDR *xdrs;
	mint_def_kind *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_integer_def(xdrs, objp)
	XDR *xdrs;
	mint_integer_def *objp;
{
	if (!xdr_int(xdrs, &objp->min)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->range)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_scalar_flags(xdrs, objp)
	XDR *xdrs;
	mint_scalar_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_scalar_def(xdrs, objp)
	XDR *xdrs;
	mint_scalar_def *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	if (!xdr_mint_scalar_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_char_flags(xdrs, objp)
	XDR *xdrs;
	mint_char_flags *objp;
{
	if (!xdr_u_int(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_char_def(xdrs, objp)
	XDR *xdrs;
	mint_char_def *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	if (!xdr_mint_char_flags(xdrs, &objp->flags)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_float_def(xdrs, objp)
	XDR *xdrs;
	mint_float_def *objp;
{
	if (!xdr_int(xdrs, &objp->bits)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_array_def(xdrs, objp)
	XDR *xdrs;
	mint_array_def *objp;
{
	if (!xdr_mint_ref(xdrs, &objp->element_type)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->length_type)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_struct_def(xdrs, objp)
	XDR *xdrs;
	mint_struct_def *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->slots.slots_val, (u_int *)&objp->slots.slots_len, ~0, sizeof(mint_ref), xdr_mint_ref)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_union_case(xdrs, objp)
	XDR *xdrs;
	mint_union_case *objp;
{
	if (!xdr_mint_const(xdrs, &objp->val)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->var)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_union_def(xdrs, objp)
	XDR *xdrs;
	mint_union_def *objp;
{
	if (!xdr_mint_ref(xdrs, &objp->discrim)) {
		return (FALSE);
	}
	if (!xdr_array(xdrs, (char **)&objp->cases.cases_val, (u_int *)&objp->cases.cases_len, ~0, sizeof(mint_union_case), xdr_mint_union_case)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->dfault)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_typed_def(xdrs, objp)
	XDR *xdrs;
	mint_typed_def *objp;
{
	if (!xdr_mint_ref(xdrs, &objp->tag)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->ref)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_interface_right(xdrs, objp)
	XDR *xdrs;
	mint_interface_right *objp;
{
	if (!xdr_enum(xdrs, (enum_t *)objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_interface_def(xdrs, objp)
	XDR *xdrs;
	mint_interface_def *objp;
{
	if (!xdr_mint_interface_right(xdrs, &objp->right)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_def(xdrs, objp)
	XDR *xdrs;
	mint_def *objp;
{
	if (!xdr_mint_def_kind(xdrs, &objp->kind)) {
		return (FALSE);
	}
	switch (objp->kind) {
	case MINT_VOID:
		break;
	case MINT_BOOLEAN:
		break;
	case MINT_FPAGE:
	        break;
	case MINT_L4STRING:
	        break;
	case MINT_INTRFC:
	        break;
	case MINT_INTEGER:
		if (!xdr_mint_integer_def(xdrs, &objp->mint_def_u.integer_def)) {
			return (FALSE);
		}
		break;
	case MINT_SCALAR:
		if (!xdr_mint_scalar_def(xdrs, &objp->mint_def_u.scalar_def)) {
			return (FALSE);
		}
		break;
	case MINT_FLOAT:
		if (!xdr_mint_float_def(xdrs, &objp->mint_def_u.float_def)) {
			return (FALSE);
		}
		break;
	case MINT_CHAR:
		if (!xdr_mint_char_def(xdrs, &objp->mint_def_u.char_def)) {
			return (FALSE);
		}
		break;
	case MINT_ARRAY:
		if (!xdr_mint_array_def(xdrs, &objp->mint_def_u.array_def)) {
			return (FALSE);
		}
		break;
	case MINT_STRUCT:
		if (!xdr_mint_struct_def(xdrs, &objp->mint_def_u.struct_def)) {
			return (FALSE);
		}
		break;
	case MINT_UNION:
		if (!xdr_mint_union_def(xdrs, &objp->mint_def_u.union_def)) {
			return (FALSE);
		}
		break;
	case MINT_INTERFACE:
		if (!xdr_mint_interface_def(xdrs, &objp->mint_def_u.interface_def)) {
			return (FALSE);
		}
		break;
	case MINT_SYSTEM_EXCEPTION:
		break;
	case MINT_ANY:
		break;
	case MINT_TYPE_TAG:
		break;
	case MINT_TYPED:
		if (!xdr_mint_typed_def(xdrs, &objp->mint_def_u.typed_def)) {
			return (FALSE);
		}
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_standard_refs(xdrs, objp)
	XDR *xdrs;
	mint_standard_refs *objp;
{
	if (!xdr_mint_ref(xdrs, &objp->void_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->bool_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->signed8_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->signed16_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->signed32_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->unsigned8_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->unsigned16_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->unsigned32_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->char8_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->float32_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->float64_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->interface_name_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->interface_invoke_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->interface_invoke_once_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->interface_service_ref)) {
		return (FALSE);
	}
	if (!xdr_mint_ref(xdrs, &objp->system_exception_ref)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_mint_1(xdrs, objp)
	XDR *xdrs;
	mint_1 *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->defs.defs_val, (u_int *)&objp->defs.defs_len, ~0, sizeof(mint_def), xdr_mint_def)) {
		return (FALSE);
	}
	if (!xdr_mint_standard_refs(xdrs, &objp->standard_refs)) {
		return (FALSE);
	}
	return (TRUE);
}


